unit DevMode;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, StdCtrls,
  ulantype, ulanglob, devsetfr, mytype, showmsg;

type
  EInvalidDeviceMode = class(Exception);

function DeviceModeCheck(var ADevMode:TDeviceMode): boolean;
  { checks if ADevMode= dmUlan is allowed (WinNT), if not,
    sets to dmApex (then changes also CurDevMode do dmApex) }

implementation

function DeviceModeCheck(var ADevMode:TDeviceMode): boolean;
  { checks if ADevMode is allowed, if not, gives
    user a chance to change it to some allowed value }
begin
  if (OSVersion.dwPlatformID <> VER_PLATFORM_WIN32_NT) and
    (ADevMode = dmUlan)
  then begin
    Result := false;
    ShowMessage('uLan driver can be loaded only under Windows NT/2000', smError, 0);
    ADevMode := {v0.14}dmApex;{/v0.14 dmUnspecified;}
    CurDeviceMode := dmApex;
  end else begin
    Result := true;
  end;
  {v0.14}
  {/v0.14
  if (ADevMode = dmUnspecified) then begin
    if DevSetupForm.ShowModal = mrOK then
      ADevMode := CurDeviceMode;
  end;}
end;

end.
