unit DevSetFr;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Spin, PBSpinEdit, PBBinHexEdit{v0.11},ExtDevIntu,
  UlDrvUtl, Modulu{/v0.11}{v0.14},ULDriver{/v0.14};

type
  TDevSetupForm = class(TForm)
    OKBtn: TButton;
    CancelBtn: TButton;
    DeviceModeGrpBox: TGroupBox;
    UlanRadioBtn: TRadioButton;
    ApexRadioBtn: TRadioButton;
    ExternalRadioBtn: TRadioButton;
    SysOpCheckBox: TCheckBox;
    PortNamePanel: TPanel;
    PortNameEdit: TEdit;
    PortNameLabel: TLabel;
    UlanPanel: TPanel;
    PortAddrEdit: TPBBinHexEdit;
    Label1: TLabel;
    PortIrqEdit: TPBSpinEdit;
    IrqLabel: TLabel;
    AutoConfigCheckBox: TCheckBox;
    MaxWindowCountEdit: TSpinEdit;
    MaxChromWindowLabel: TLabel;
    procedure OKBtnClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure ApexRadioBtnClick(Sender: TObject);
    procedure UlanRadioBtnClick(Sender: TObject);
    procedure ExternalRadioBtnClick(Sender: TObject);
  private
    { Private declarations }
    procedure DecideWhatToSee;
  public
    { Public declarations }
  end;

var
  DevSetupForm: TDevSetupForm;

implementation
uses ulantype, ulanglob;

{$R *.DFM}

procedure TDevSetupForm.OKBtnClick(Sender: TObject);
var chn:boolean;
begin
  if UlanRadioBtn.Checked then begin
    CurDeviceMode := dmUlan;
    {v0.11}
    Modules.ULDrvFailed := false;
    {/v0.11}
  end else if ApexRadioBtn.Checked then
    CurDeviceMode := dmApex
  else if ExternalRadioBtn.Checked then
    CurDeviceMode := dmExtDev;
  CurPortName := PortNameEdit.Text;
  if SysOpCheckBox.Checked then
    UserMode := umSysOp
  else
    UserMode := umUser;
  {v0.14}
  chn := false;
  if PortAddr <> PortAddrEdit.AsInteger then begin
    PortAddr := PortAddrEdit.AsInteger;
    chn := true;
  end;
  if PortIrq  <> PortIrqEdit.Value then begin
    PortIrq := PortIrqEdit.Value;
    chn := true;
  end;
  {/v0.14
  PortAddr := PortAddrEdit.AsInteger;
  PortIrq := PortIrqEdit.Value;}
  {v0.11}
  if {v0.14}chn {/v0.14 CurDeviceMode = dmUlan} then begin
    ULDrvReqReadWrite(false, PortAddr, PortIrq, PCUlanAddr);
  end;
  {/v0.11}
  AutoConfigDriver := AutoConfigCheckBox.Checked;
  {v0.18}
  MaxSpectrumFormCount := MaxWindowCountEdit.Value;
  {/v0.18}
end;

procedure TDevSetupForm.FormActivate(Sender: TObject);
{v0.14}
var d: TULDriver;
{/v0.14}
begin
  DecideWhatToSee;

  UlanRadioBtn.Enabled := (OSVersion.dwPlatformId = VER_PLATFORM_WIN32_NT);
  if (not UlanRadioBtn.Enabled) and (CurDeviceMode = dmUlan) then
   CurDeviceMode := dmUnspecified;

  case CurDeviceMode of
    dmUlan: UlanRadioBtn.Checked := true;
    dmApex: ApexRadioBtn.Checked := true;
    dmExtDev: ExternalRadioBtn.Checked := true;
  else
    ApexRadioBtn.Checked := true;
  end;
  SysOpCheckBox.Checked := (UserMode = umSysOp);
  PortNameEdit.Text := CurPortName;
  {v0.14}
  d := Modules.ULDrv;
  if d <> nil then begin
    PortAddr := d.PortAddr;
    PortIrq := d.PortIrq;
    {PCUlanAddr := d.PCUlanAddr;}
  end else
  {/v0.14}
  begin
    {v0.11}
    ULDrvReqReadWrite(true, PortAddr, PortIrq, PCUlanAddr);
    {/v0.11}
  end;
  PortAddrEdit.AsInteger := PortAddr;
  PortIrqEdit.Value := PortIrq;
  AutoConfigCheckBox.Checked := AutoConfigDriver;
  {v0.18}
  MaxWindowCountEdit.Value := MaxSpectrumFormCount;
  {/v0.18}
end;

procedure TDevSetupForm.DecideWhatToSee;
begin
  if UlanRadioBtn.Checked then begin
    UlanPanel.Visible := true;
    PortNamePanel.Visible := false;
  end else begin
    UlanPanel.Visible := false;
    PortNamePanel.Visible := true;
  end;
  {v0.11}
  {v0.14}
  {/v0.14
  ExternalRadioBtn.Visible := ExtDevPresent('');}
  {/v0.11}
end;

procedure TDevSetupForm.ApexRadioBtnClick(Sender: TObject);
begin
  DecideWhatToSee;
end;

procedure TDevSetupForm.UlanRadioBtnClick(Sender: TObject);
begin
  DecideWhatToSee;
end;

procedure TDevSetupForm.ExternalRadioBtnClick(Sender: TObject);
begin
  DecideWhatToSee;
end;

end.
