unit FiltDlg;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ulantype, ulanglob, StdCtrls, ExtCtrls, showmsg;

type
  TFilterParsForm = class(TForm)
    FilterTypeGrp: TRadioGroup;
    AvgPointCountEdit: TEdit;
    Filter1Edit: TEdit;
    AvgPointCountLbl: TLabel;
    Filter1Lbl: TLabel;
    OKBtn: TButton;
    CancelBtn: TButton;
    procedure FilterTypeGrpClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure DecideWhatToSee;
    procedure ParamsToControls(var fp:TFilterPars);
    procedure ControlsToParams(var fp:TFilterPars);
  end;

var
  FilterParsForm: TFilterParsForm;

implementation

{$R *.DFM}

procedure TFilterParsForm.FilterTypeGrpClick(Sender: TObject);
begin
  DecideWhatToSee;
end;

procedure TFilterParsForm.FormActivate(Sender: TObject);
begin
  DecideWhatToSee;
end;

procedure TFilterParsForm.DecideWhatToSee;
begin
  case TFilterType(FilterTypeGrp.ItemIndex) of
    ftNone: begin
      AvgPointCountEdit.Visible := false;
      AvgPointCountLbl.Visible := false;
      Filter1Edit.Visible := false;
      Filter1Lbl.Visible := false;
    end;
    ftAvg: begin
      AvgPointCountEdit.Visible := true;
      AvgPointCountLbl.Visible := true;
      Filter1Edit.Visible := false;
      Filter1Lbl.Visible := false;
    end;
    ftFilter1: begin
      AvgPointCountEdit.Visible := false;
      AvgPointCountLbl.Visible := false;
      Filter1Edit.Visible := true;
      Filter1Lbl.Visible := true;
    end;
  end;
end;

procedure TFilterParsForm.ParamsToControls(var fp:TFilterPars);
begin
  FilterTypeGrp.ItemIndex := ord(fp.FilterType);
  AvgPointCountEdit.Text := IntToStr(fp.AvgPointCount);
  Filter1Edit.Text := FloatToStr(fp.Filter1);
  DecideWhatToSee;
end;

procedure TFilterParsForm.ControlsToParams(var fp:TFilterPars);
var
  s:shortstring;
  p:integer;
  ch :char;
begin
  fp.FilterType := TFilterType(FilterTypeGrp.ItemIndex);
  fp.AvgPointCount := StrToInt(AvgPointCountEdit.Text);
  s := Filter1Edit.Text;
  if DecimalSeparator = '.' then
    ch := ','
  else
    ch := '.';
  p := pos(ch, s);
  if p <> 0 then
    s[p] := DecimalSeparator;
  fp.Filter1 := StrToFloat(s);
  if (fp.Filter1 < 0) or (fp.Filter1 > 1) then begin
    {ShowMessage('Invalid param}
    fp.Filter1 := 0.5;
  end;
end;

procedure TFilterParsForm.OKBtnClick(Sender: TObject);
var f:TFilterPars;
begin
  ControlsToParams(f);
  CurFilterPars.FilterType := f.FilterType;
  CurFilterPars.AvgPointCount := f.AvgPointCount;
  CurFilterPars.Filter1 := f.Filter1;
  { make these params new defaults }
end;

end.
