unit GWUtil_1;
{----------------------------------------------
GW Utility functions

98-05-25 GW original

-----------------------------------------------}
interface

Function HexToIntDef(Hex: string; Def: integer): integer;

Const HexDigits = '0123456789ABCDEF';

Type
  IntAsBytes = packed record
    b0, b1, b2, b3: byte;
  end;


//------------------------------------------------------
implementation
//------------------------------------------------------

//------------------------------------------------------
Function HexToIntDef(Hex: string; Def: integer): integer;
//------------------------------------------------------
Var
  Total, Dig: integer;
  ChPos, L: integer;
  Ch: char;
Label Err;
Begin
  Total := 0;
  L := Length(Hex);
  For ChPos := 1 to L do
  Begin
    Ch := upcase(Hex[ChPos]);
    Dig := Pos(Ch, HexDigits) - 1;
    If Dig = -1 then
    Begin
      Total := Def;
      goto Err;
    end;
    Total := Total * 16 + Dig;
  end;
Err:
  result := Total;
end;

end.
 