program h2pas;
{converts C constatns file to pascal constats file }
uses dos,crt,mylib;

procedure Convert(InFile, OutFile:PathStr);
var
  s,valu:string;
  p:byte;
  fin,fout:text;
  d:dirstr;
  n:namestr;
  e:extstr;
begin
  InFile := ReplaceExt(InFile, '.H', false);
  if OutFile = '' then
    OutFile := ReplaceExt(InFile, '.PAS', true)
  else
    OutFile := ReplaceExt(InFile, '.PAS', false);
  assign(fin, InFile);
  reset(fin);
  assign(fout, OutFile);
  rewrite(fout);
  FSplit(OutFile, d, n, e);
  writeln(fout,'unit ' + n + ';');
  writeln(fout,'interface');
  writeln(fout,'const');

{  writeln(}
  while not eof(fin) do begin
    readln(fin, s);
    p := pos('#', s);
    if p > 0 then begin
      p := pos(' ',s);
      if p = 0 then
        p := pos(#9,s);
      s := trim(copy(s, p, 255));{split off #define}
      p := pos(' ',s);
      if p = 0 then
        p := pos(#9,s);
      valu := trim(copy(s, succ(p),255));
{      dec(valu[0]);{remove ';'}
      s := trim(copy(s,1,pred(p)));
      writeln(fout, '  ', s, ' = ', valu,';');
    end;
  end;
  writeln(fout,'implementation');
  writeln(fout,'end.');
  close(fin);
  close(fout);
end;

begin
  if paramcount = 0 then begin
    writeln('Usage: H2PAS file1[.H] [file2[.PAS]]');
    writeln(' Converts C constats file to PAS constats file.');
  end else begin
    convert(paramstr(1), paramstr(2));
  end;
end.

