unit ULAType;
  { Format of ULA = analysis  record (head of ULA datafiles),
    source for MakeComp program }
interface
uses
  UlanType, ULRecTyp;
const
  ULAExt = '.ULA';
  ULAID = ord('U') + 256* ord('L') + 256 * 256 * ord('A');

type
  TULARec = packed record {<Caption="Sample" RootChild=1
     ChildRecIDs=ULADID,ULAFID,ULIID,ULMID HasRecName=1
     Uses=ULADType,ULAFType,ULIType,ULMType
     Enabled=1 Visible=1>}
    { Raw data holded in TULSDObj object, filtered
      data holded in TULSFObj object }
    Head: TULRecHead;
    Info: TULRecInfo;
    SampleName:TSampleName;{<Enabled=1>}
      { Name of the sample. }
    SampleDesc:TSampleDesc;{<Enabled=1 Caption="Sample Desc.">}
      { Longer description of the sample. }
    Amount: TSampleAmount;{<Enabled=1>}
      { Amount of the sample (in user chosen units) }
    ISTDAmount: TSampleAmount;{<Enabled=1>}
    InjectionVolume: TInjectionVolume;{<Enabled=1 Caption="Inj.volume[ul]">}
    CalibrationStandard: boolean;{<Enabled=1>}
      { Is this analysis beeing used as calibration standard? }
    ExternalStartEnabled: boolean;{<Enabled=1>}
    UserID:TUserID;{<Enabled=1>}
      { User id of the analyst. }
    UserName:TUserName;{<Enabled=1>}
      { Short name of the analyst (copy from ulu file, for the case the UserID
        record will be deleted from ulu file). }
    {InstrumentFileName TULFileName - now as Child record }
      { Name of the file that contains parameters of instruments that
        were used for measurement (UliRec),
        - before acqusition start it can be template file,
        - after acqusition started, the template content is copied to
          file that will be permanently associated with newly creating data file
          (same base name, usually different extension then raw data file,
          although it can be even in the ULS datafile - after TULSRec before
          Data )
        - can not be changed after acquisition started }
    {MethodFileName TULFileName - now as Child record }
      { Name of the file that contains method parameters (UlmRec) used last
        time for evaluation of the data; can be changed even after acquisition. }
  end;
  PULARec = ^TULARec;

implementation

end.
