unit uledutl;{v0.13}
interface
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls,
  MyType, UlanType, ULRecTyp, ULObju, PropUtl, WinUtl;

type
  TFormULObjOption = (foCaption, foOnlyFileNames);
    { foCaption - set form caption to Obj.Desc }
  TFormULObjOptions = set of TFormULObjOption;

procedure FormToULObj(AForm: TForm; AObj: TULObj; AOptions: TFormULObjOptions; const AStartDir: string);
  { Copy values from AForm's components (TEdit, TCheckBox,...) to AObj's fields }

procedure ULObjToForm(AObj: TULObj; AForm: TForm; AOptions: TFormULObjOptions; const AStartDir: string);
  { Copy values from AObj's fields to AForm's components (TEdit, TCheckBox,...)  }

implementation

procedure FormToULObj(AForm: TForm; AObj: TULObj; AOptions: TFormULObjOptions; const AStartDir: string);
var
  c: TObject;
  n: shortstring;
  v: string;
  i: integer;
  f: TULObjField;
{  d: string;
  dch:boolean;}

  Buffer: PChar;
  Size: Integer;

begin
  if (AForm = nil) or (AObj = nil) then
    exit;
  with AForm do begin
    for i := 0 to ComponentCount - 1 do begin
      c := TObject(Components[i]);
      if c is TEdit then begin
        with c as TEdit do begin
          n := copy(Name, 1, length(Name) - 4);
          v := Text;
          if AObj.HasField(n, f) then begin
            if f.FldDesc.IsFileName then begin
              if RelativeFileName(AStartDir, f.UsrValue) <> v then begin
                f.UsrValue := v;
              end;
            end else begin
              {v0.14}
              if not (foOnlyFileNames in AOptions) then
              {/v0.14}
              begin
                f.UsrValue := v;
              end;
            end;
          end;
        end;
      end else if c is TComboBox then begin
        {v0.14}
        if not (foOnlyFileNames in AOptions) then
        {/v0.14}
        with c as TComboBox do begin
          n := copy(Name, 1, length(Name) - 4);
          v := Text;
          if AObj.HasField(n, f) then
            f.UsrValue := v;
        end;
      end else if c is TCheckBox then begin
        {v0.14}
        if not (foOnlyFileNames in AOptions) then
        {/v0.14}
        with c as TCheckBox do begin
          n := copy(Name, 1, length(Name) - 4);
          if Checked then
            v := 'True'
          else
            v := 'False';
          if AObj.HasField(n, f) then
            f.UsrValue := v;
        end;
      end else if c is TMemo then begin
        {v0.14}
        if not (foOnlyFileNames in AOptions) then
        {/v0.14}
        with c as TMemo do begin
          n := copy(Name, 1, length(Name) - 4);
          if AObj.HasField(n, f) then begin
            SelectAll;
            Size := SelLength + Lines.Count * 2 + 1;
            GetMem(Buffer, Size);
            try
              GetSelTextBuf(Buffer, Size);
              f.UsrValue := StrPas(Buffer);
            finally
              FreeMem(Buffer, Size);
            end;
          end;
        end;
      end;
    end;
    SendMessage(Application.MainForm.Handle, WM_APPMESSAGE, cmULObjAfterEdit,
      longint(AObj));
  end;
end;

procedure ULObjToForm(AObj: TULObj; AForm: TForm; AOptions: TFormULObjOptions; const AStartDir: string);
var
  c: TObject;
  pn, n: shortstring;
  v: string;
  i, j: integer;
{  dt: TDateTime;}

  buffer:PChar;
  size:integer;
  {v0.14}
  k: integer;
  {/v0.14}
begin
  if (AObj = nil) or (AForm = nil) then
    exit;
  {v0.14} {/v0.14 GetDir(0, AStartDir);}
  with AForm do begin
    if foCaption in AOptions then
      Caption := AObj.ObjDesc.Caption + ' (' + AObj.RootFileDir + ') '
        + ExtractFileName(AObj.RootFileName);
    for i := 0 to AObj.ObjDesc.FieldCount - 1 do begin
      pn := AObj.ObjDesc.Fields[i].Name;
      v := AObj.Fields[i].UsrValue;
      n := pn + 'Edit';
      for j := 0 to ComponentCount - 1 do begin
        c := Components[j];
        if c is TEdit then begin
          with c as TEdit do {v0.13 if force or (not Modified) then{/v0.13} begin
            if Name = n then begin
              {v0.15}
              if AObj.IsFlagSet(rfWriteLocked) then
                ReadOnly := true;
              {/v0.15}
              {v0.13}
              if AObj.Fields[i].FldDesc.IsFileName then begin
                Text := RelativeFileName(AStartDir, v);
              end else
              {/v0.13}
              begin
               {v0.14} if not (foOnlyFileNames in AOptions) then {/v0.14}
               Text := v;
              end;
            end;
          end;
        end else if c is TComboBox then begin
         {v0.14} if not (foOnlyFileNames in AOptions) then {/v0.14}
          with c as TComboBox do {v0.13 if force or (not Modified) then{/v0.13} begin
            if Name = n then begin
              {v0.15}
              if AObj.IsFlagSet(rfWriteLocked) then
                Enabled := false;
              {/v0.15}
              {v0.14}
              if AObj.ObjDesc.Fields[i].IsULEnum then begin
                AObj.FillULEnumNames(i, Items);
              end else
              {/v0.14}
              begin
                FillEnumNames(AObj, pn, Items);
              end;
              {v0.14}
              if Style = csDropDownList then begin
                for k := 0 to Items.Count - 1 do begin
                  if Items[k] = v then begin
                    ItemIndex := k;
                    break;
                  end;
                end;
              end else
              {/v0.14}
              begin
                Text := v;
              end;
            end;
          end;
        end else if c is TCheckBox then {v0.13 if force or (not Modified) then{/v0.13} begin
         {v0.14} if not (foOnlyFileNames in AOptions) then {/v0.14}
          with c as TCheckBox do begin
            if Name = n then begin
              {v0.15}
              if AObj.IsFlagSet(rfWriteLocked) then
                Enabled := false;
              {/v0.15}
              Checked := (v = 'True');
            end;
          end;
        end else if c is TMemo then begin
         {v0.14} if not (foOnlyFileNames in AOptions) then {/v0.14}
          with c as TMemo do begin
            if Name = n then begin
              {v0.15}
              if AObj.IsFlagSet(rfWriteLocked) then
                Enabled := false;
              {/v0.15}
              SelectAll;
              size := length(v) + 1;
              GetMem(Buffer, size);
              try
                StrPCopy(Buffer, v);
                SetSelTextBuf(Buffer);
              finally
                FreeMem(Buffer);
              end;
            end;
          end;
        end;
      end;
    end;
  end;
end;


end.
