unit ULGFObju;
{ Generated by MakeComp 1.02 from ULGFTYPE.PAS. Don't modify manually !!! }
interface
uses Classes, UlanType, ULRecTyp, ULObju, 
  ULGFType;

type
  TULGFObj = class(TULObj)
  protected
    function GetTime: TAcqTime;
    procedure SetTime(ATime: TAcqTime);
    function GetFlowRate: TFlowRate;
    procedure SetFlowRate(AFlowRate: TFlowRate);
    function GetMinRecLen: TULRecLen; override;
  public
    constructor Create(AOwner:TULObj);
    function GetULRecDesc: PULRecDesc; override;
    function GetSortStr: string; override;
  published
    property Time: TAcqTime
      read GetTime write SetTime;
    property FlowRate: TFlowRate
      read GetFlowRate write SetFlowRate;
  end;

const
  ULGFFldDescs: array[0..1] of TULFldDesc = (
    (
     Caption: '';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 1;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0
    ),
    (
     Caption: '';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 1;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0
    )
  );
  ULGFRecDesc: TULRecDesc = (
    Caption: 'Gradient Flow Rec.';
    ChildRecIDsStr: '';
    ChildRecIDs: nil;
    ChildRecIDCount: 0;
    FldCount: 2;
    Flds: @ULGFFldDescs;
    Flags: rfEnabled + rfVisible;
    SortExp: 'NumToSortStr(Time)';
    EditFieldList: '';
    BrowseFieldList: ''
   );

implementation

{TULGFObj}
function TULGFObj.GetMinRecLen: TULRecLen;
begin
  GetMinRecLen := sizeof(TULGFRec);
end;

constructor TULGFObj.Create(AOwner: TULObj);
begin
  inherited Create(TComponent(AOwner), ULGFID);
end;

function TULGFObj.GetULRecDesc: PULRecDesc;
begin
  Result := @ULGFRecDesc;
end;

function TULGFObj.GetSortStr: string;
begin
  Result := NumToSortStr(Time);
end;
procedure TULGFObj.SetTime(ATime: TAcqTime);
begin
  if PULGFRec(Rec)^.Time <> ATime then begin
    PULGFRec(Rec)^.Time := ATime;
    DoChange;
  end;
end;

function TULGFObj.GetTime: TAcqTime;
begin
  GetTime := PULGFRec(Rec)^.Time;
end;

procedure TULGFObj.SetFlowRate(AFlowRate: TFlowRate);
begin
  if PULGFRec(Rec)^.FlowRate <> AFlowRate then begin
    PULGFRec(Rec)^.FlowRate := AFlowRate;
    DoChange;
  end;
end;

function TULGFObj.GetFlowRate: TFlowRate;
begin
  GetFlowRate := PULGFRec(Rec)^.FlowRate;
end;

{/TULGFObj}

end.
