unit ULMObju;
{ Generated by MakeComp 1.02 from ULMTYPE.PAS. Don't modify manually !!! }
interface
uses Classes, UlanType, ULRecTyp, ULObju, 
  ULBType,ULMFType,ULPType,
  ULMType;

type
  TULMObj = class(TULObj)
  protected
    function GetMethodTemplate: TULFileName;
    procedure SetMethodTemplate(AMethodTemplate: TULFileName);
    function GetCalibrationFileName: TULFileName;
    procedure SetCalibrationFileName(ACalibrationFileName: TULFileName);
    function GetMethodFileName: TULFileName;
    procedure SetMethodFileName(AMethodFileName: TULFileName);
    function GetDilution: TDilution;
    procedure SetDilution(ADilution: TDilution);
    function GetBaseMinInterval: single;
    procedure SetBaseMinInterval(ABaseMinInterval: single);
    function GetBaseMaxDiff: single;
    procedure SetBaseMaxDiff(ABaseMaxDiff: single);
    function GetMinPeakHeight: single;
    procedure SetMinPeakHeight(AMinPeakHeight: single);
    function GetMinPeakWidth: single;
    procedure SetMinPeakWidth(AMinPeakWidth: single);
    function GetUseNegativePeaks: boolean;
    procedure SetUseNegativePeaks(AUseNegativePeaks: boolean);
    function GetCalcAmounts: boolean;
    procedure SetCalcAmounts(ACalcAmounts: boolean);
    function GetUseCalibrationFile: boolean;
    procedure SetUseCalibrationFile(AUseCalibrationFile: boolean);
    function GetUseInternalStandard: boolean;
    procedure SetUseInternalStandard(AUseInternalStandard: boolean);
    function GetFactor: TFactor;
    procedure SetFactor(AFactor: TFactor);
    function GetCalibrationFileAge: integer;
    procedure SetCalibrationFileAge(ACalibrationFileAge: integer);
    function GetMinRecLen: TULRecLen; override;
  public
    constructor Create(AOwner:TULObj);
    function GetULRecDesc: PULRecDesc; override;
  published
    property MethodTemplate: TULFileName
      read GetMethodTemplate write SetMethodTemplate;
    property CalibrationFileName: TULFileName
      read GetCalibrationFileName write SetCalibrationFileName;
    property MethodFileName: TULFileName
      read GetMethodFileName write SetMethodFileName;
    property Dilution: TDilution
      read GetDilution write SetDilution;
    property BaseMinInterval: single
      read GetBaseMinInterval write SetBaseMinInterval;
    property BaseMaxDiff: single
      read GetBaseMaxDiff write SetBaseMaxDiff;
    property MinPeakHeight: single
      read GetMinPeakHeight write SetMinPeakHeight;
    property MinPeakWidth: single
      read GetMinPeakWidth write SetMinPeakWidth;
    property UseNegativePeaks: boolean
      read GetUseNegativePeaks write SetUseNegativePeaks;
    property CalcAmounts: boolean
      read GetCalcAmounts write SetCalcAmounts;
    property UseCalibrationFile: boolean
      read GetUseCalibrationFile write SetUseCalibrationFile;
    property UseInternalStandard: boolean
      read GetUseInternalStandard write SetUseInternalStandard;
    property Factor: TFactor
      read GetFactor write SetFactor;
    property CalibrationFileAge: integer
      read GetCalibrationFileAge write SetCalibrationFileAge;
  end;

const
  ULMChildRecIDs: array[0..2] of TULRecID = (
    ULBID,ULMFID,ULPID
  );
  ULMFldDescs: array[0..13] of TULFldDesc = (
    (
     Caption: 'Method template';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 37;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0
    ),
    (
     Caption: 'Calibration file';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 37;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0
    ),
    (
     Caption: '';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 37;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0
    ),
    (
     Caption: '';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 0;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0
    ),
    (
     Caption: 'Base.min.interval [min]';
     Hint: 'What is the minimal width of baseline section that should be autodetected';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 1;
     UserCoef: 60.00;
     NumDec: 2;
     ValuesSourceRecID: 0
    ),
    (
     Caption: '';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 1;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0
    ),
    (
     Caption: 'Min. peak height';
     Hint: 'What it the minimal height of the peak that should be autodetected';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 1;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0
    ),
    (
     Caption: 'Min. peak width [min]';
     Hint: 'What is the minimal width of peak that should be autodetected';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 1;
     UserCoef: 60.00;
     NumDec: 2;
     ValuesSourceRecID: 0
    ),
    (
     Caption: '';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 1;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0
    ),
    (
     Caption: '';
     Hint: 'Should peak amounts be calculated?';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 1;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0
    ),
    (
     Caption: '';
     Hint: 'Should peak amounts be calculated using calibration file?';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 1;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0
    ),
    (
     Caption: '';
     Hint: 'Should peak amounts be calculated using internal standard?';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 1;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0
    ),
    (
     Caption: '';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 1;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0
    ),
    (
     Caption: '';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 8;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0
    )
  );
  ULMRecDesc: TULRecDesc = (
    Caption: 'Method';
    ChildRecIDsStr: 'ULBID,ULMFID,ULPID';
    ChildRecIDs: @ULMChildRecIDs;
    ChildRecIDCount: 3;
    FldCount: 14;
    Flds: @ULMFldDescs;
    Flags: rfChildAllowed + rfRootChild + rfEnabled + rfVisible;
    SortExp: '';
    EditFieldList: '';
    BrowseFieldList: ''
   );

implementation

{TULMObj}
function TULMObj.GetMinRecLen: TULRecLen;
begin
  GetMinRecLen := sizeof(TULMRec);
end;

constructor TULMObj.Create(AOwner: TULObj);
begin
  inherited Create(TComponent(AOwner), ULMID);
  BaseMinInterval := 30;
  BaseMaxDiff := 5e-5;
  MinPeakWidth := 12;
  MinPeakHeight := 0.01;
end;

function TULMObj.GetULRecDesc: PULRecDesc;
begin
  Result := @ULMRecDesc;
end;

procedure TULMObj.SetMethodTemplate(AMethodTemplate: TULFileName);
begin
  if PULMRec(Rec)^.MethodTemplate <> AMethodTemplate then begin
    PULMRec(Rec)^.MethodTemplate := AMethodTemplate;
    DoChange;
  end;
end;

function TULMObj.GetMethodTemplate: TULFileName;
begin
  GetMethodTemplate := PULMRec(Rec)^.MethodTemplate;
end;

procedure TULMObj.SetCalibrationFileName(ACalibrationFileName: TULFileName);
begin
  if PULMRec(Rec)^.CalibrationFileName <> ACalibrationFileName then begin
    PULMRec(Rec)^.CalibrationFileName := ACalibrationFileName;
    DoChange;
  end;
end;

function TULMObj.GetCalibrationFileName: TULFileName;
begin
  GetCalibrationFileName := PULMRec(Rec)^.CalibrationFileName;
end;

procedure TULMObj.SetMethodFileName(AMethodFileName: TULFileName);
begin
  if PULMRec(Rec)^.MethodFileName <> AMethodFileName then begin
    PULMRec(Rec)^.MethodFileName := AMethodFileName;
    DoChange;
  end;
end;

function TULMObj.GetMethodFileName: TULFileName;
begin
  GetMethodFileName := PULMRec(Rec)^.MethodFileName;
end;

procedure TULMObj.SetDilution(ADilution: TDilution);
begin
  if PULMRec(Rec)^.Dilution <> ADilution then begin
    PULMRec(Rec)^.Dilution := ADilution;
    DoChange;
  end;
end;

function TULMObj.GetDilution: TDilution;
begin
  GetDilution := PULMRec(Rec)^.Dilution;
end;

procedure TULMObj.SetBaseMinInterval(ABaseMinInterval: single);
begin
  if PULMRec(Rec)^.BaseMinInterval <> ABaseMinInterval then begin
    PULMRec(Rec)^.BaseMinInterval := ABaseMinInterval;
    DoChange;
  end;
end;

function TULMObj.GetBaseMinInterval: single;
begin
  GetBaseMinInterval := PULMRec(Rec)^.BaseMinInterval;
end;

procedure TULMObj.SetBaseMaxDiff(ABaseMaxDiff: single);
begin
  if PULMRec(Rec)^.BaseMaxDiff <> ABaseMaxDiff then begin
    PULMRec(Rec)^.BaseMaxDiff := ABaseMaxDiff;
    DoChange;
  end;
end;

function TULMObj.GetBaseMaxDiff: single;
begin
  GetBaseMaxDiff := PULMRec(Rec)^.BaseMaxDiff;
end;

procedure TULMObj.SetMinPeakHeight(AMinPeakHeight: single);
begin
  if PULMRec(Rec)^.MinPeakHeight <> AMinPeakHeight then begin
    PULMRec(Rec)^.MinPeakHeight := AMinPeakHeight;
    DoChange;
  end;
end;

function TULMObj.GetMinPeakHeight: single;
begin
  GetMinPeakHeight := PULMRec(Rec)^.MinPeakHeight;
end;

procedure TULMObj.SetMinPeakWidth(AMinPeakWidth: single);
begin
  if PULMRec(Rec)^.MinPeakWidth <> AMinPeakWidth then begin
    PULMRec(Rec)^.MinPeakWidth := AMinPeakWidth;
    DoChange;
  end;
end;

function TULMObj.GetMinPeakWidth: single;
begin
  GetMinPeakWidth := PULMRec(Rec)^.MinPeakWidth;
end;

procedure TULMObj.SetUseNegativePeaks(AUseNegativePeaks: boolean);
begin
  if PULMRec(Rec)^.UseNegativePeaks <> AUseNegativePeaks then begin
    PULMRec(Rec)^.UseNegativePeaks := AUseNegativePeaks;
    DoChange;
  end;
end;

function TULMObj.GetUseNegativePeaks: boolean;
begin
  GetUseNegativePeaks := PULMRec(Rec)^.UseNegativePeaks;
end;

procedure TULMObj.SetCalcAmounts(ACalcAmounts: boolean);
begin
  if PULMRec(Rec)^.CalcAmounts <> ACalcAmounts then begin
    PULMRec(Rec)^.CalcAmounts := ACalcAmounts;
    DoChange;
  end;
end;

function TULMObj.GetCalcAmounts: boolean;
begin
  GetCalcAmounts := PULMRec(Rec)^.CalcAmounts;
end;

procedure TULMObj.SetUseCalibrationFile(AUseCalibrationFile: boolean);
begin
  if PULMRec(Rec)^.UseCalibrationFile <> AUseCalibrationFile then begin
    PULMRec(Rec)^.UseCalibrationFile := AUseCalibrationFile;
    DoChange;
  end;
end;

function TULMObj.GetUseCalibrationFile: boolean;
begin
  GetUseCalibrationFile := PULMRec(Rec)^.UseCalibrationFile;
end;

procedure TULMObj.SetUseInternalStandard(AUseInternalStandard: boolean);
begin
  if PULMRec(Rec)^.UseInternalStandard <> AUseInternalStandard then begin
    PULMRec(Rec)^.UseInternalStandard := AUseInternalStandard;
    DoChange;
  end;
end;

function TULMObj.GetUseInternalStandard: boolean;
begin
  GetUseInternalStandard := PULMRec(Rec)^.UseInternalStandard;
end;

procedure TULMObj.SetFactor(AFactor: TFactor);
begin
  if PULMRec(Rec)^.Factor <> AFactor then begin
    PULMRec(Rec)^.Factor := AFactor;
    DoChange;
  end;
end;

function TULMObj.GetFactor: TFactor;
begin
  GetFactor := PULMRec(Rec)^.Factor;
end;

procedure TULMObj.SetCalibrationFileAge(ACalibrationFileAge: integer);
begin
  if PULMRec(Rec)^.CalibrationFileAge <> ACalibrationFileAge then begin
    PULMRec(Rec)^.CalibrationFileAge := ACalibrationFileAge;
    DoChange;
  end;
end;

function TULMObj.GetCalibrationFileAge: integer;
begin
  GetCalibrationFileAge := PULMRec(Rec)^.CalibrationFileAge;
end;

{/TULMObj}

end.
