unit ulmaglob;
interface
uses
  Classes, Forms,
  WinUtl,
  LogType, Logu, {v0.19} PortLog,{/v0.19}
  ConfType, Confu,
  ULDrvTyp, ULDriver, DrvLogu,
  ul_lcabs, ModuType, Modulu{v0.14}, Channelsu, ExtDevIntu{/v0.14};

const
{ini.lst}
  UVDetAddr:longint = 3;
    { ulan device address of UV detector }
  UVDetSII:PScanInputInfo = nil;
    { handle for receiving data from UV detector }
{/ini.lst}
  IsInTimer:boolean = false;
    { recursion preventer for ulMDoTimer event }


function ulMInit(InitRcv:boolean):boolean;
  { ulMaster initialization, called from ulMaster main window create }

function ulMDoTimer:boolean;
  { timer triggered method }

function ulMDone:boolean;
  { ulMaster deinitialization, called from ulMaster main window destroy }

implementation

{const
  GlobalVars: PVarRecordArray = nil;}

function ulMInit(InitRcv:boolean):boolean;
begin
{  GetMem(GlobalVars, sizeof(TVarRecordArray) * MaxVarsCount);
  ConfigSetGlobals(GlobalVars, MaxVarsCount);}
  LogRegister;
  ConfigInit(Application.ExeName);
  SysLogInit;
  DrvLogInit;
  {v0.14}
  ExtDevs := TExtDevs.Create;
  Modules := TModules.Create;
  Channels := TChannels.Create;
  {/v0.14}
  if InitRcv then
    RcvInit(UVDetSII, UVDetAddr);
  {v0.19}
  PortLogInit;
  {/v0.19}
  ulMInit := true;
end;

function ulMDoTimer:boolean;
begin
  ulMDoTimer := false;
  if IsInTimer then
    exit;
  try
    IsInTimer := true;
    if Modules <> nil then begin
      Modules.DoTimer;
    end;
    RcvRun(UVDetSII);
    ulMDoTimer := true;
  finally
    IsInTimer := false;
  end;
end;

function ulMDone:boolean;
begin
  ConfigDone;
  RcvDone(UVDetSII);
  {v0.14}
  ClassFree(Channels);
  {/v0.14}
  ClassFree(Modules);
  {v0.14}
  ClassFree(ExtDevs);
  {/v0.14}
  {v0.19}
  PortLogDone;
  {/v0.19}
  DrvLogDone;
  SysLogDone;
  ulMDone := true;
end;

end.
