unit ulndtype;
{ ULND channel device description record.
  Channel is group of devices that is used to control
  chromatograpy. ULNObj is owner of several ULNDObj objects
  - list of names of devices (specified in ULDObj/ULDRObj)
  that belong to this channel. One device can belong to
  more channels.  }
interface

uses
  UlanType, ULRecTyp;{ULREC.LST}

const
  ULNDID = ord('U') + 256*ord('L') + 256*256*ord('N') + 256*256*256*ord('D');

type
  TULNDRec = packed record {<Caption="Channel device" Uses=ULDType
    Enabled=1 Visible=1 HasRecName=1>}
    Head: TULRecHead;
    Info: TULRecInfo;
    DeviceName: TDeviceName;{<Enabled=1 Type=ULEnum ValuesSourceRecID=ULDID>}
     { System wide unique name of the device in ULD list }
  end;
  PULNDRec = ^TULNDRec;

implementation

end.
