unit ULRecUtl;
{ utility methods for TULxxRec/Obj records/objects }
interface
uses
  Math, ULRecTyp;

function ULRecIDToStr(ARecID: TULRecID): TULRecIDStr;
function StrToULRecID(const S: TULRecIDStr): TULRecID;
{v0.14}
function ULRecIDToStrStrip(ARecID: TULRecID): TULRecIDStr;
  { strips eventual #0 char at the end }
{/v0.14}
implementation

function ULRecIDToStr(ARecID: TULRecID): TULRecIDStr;
var c: array[0..3] of char absolute ARecID;
begin
  ULRecIDToStr := c[0]+c[1]+c[2]+c[3];
end;

function StrToULRecID(const S: TULRecIDStr): TULRecID;
var l: longint;
begin
  l := 0;
  move(s[1], l, min(length(s),sizeof(l)));
  Result := l;
end;

{v0.14}
function ULRecIDToStrStrip(ARecID: TULRecID): TULRecIDStr;
  { strips eventual #0 char at the end }
begin
  Result := ULRecIDToStr(ARecID);
  if (Result <> '') and (Result[length(Result)] = #0) then
    Result := copy(Result, 1, length(Result) - 1);
  Result := Result;
end;
{/v0.14}

end.
