unit ULVOObju;
{ Generated by MakeComp 1.02 from ULVOTYPE.PAS. Don't modify manually !!! }
interface
uses Classes, UlanType, ULRecTyp, ULObju, 
  ULVOType;

type
  TULVOObj = class(TULObj)
  protected
    function GetShowData: boolean;
    procedure SetShowData(AShowData: boolean);
    function GetShowPeaks: boolean;
    procedure SetShowPeaks(AShowPeaks: boolean);
    function GetShowAxis: boolean;
    procedure SetShowAxis(AShowAxis: boolean);
    function GetShowBaseline: boolean;
    procedure SetShowBaseline(AShowBaseline: boolean);
    function GetShowHeader: boolean;
    procedure SetShowHeader(AShowHeader: boolean);
    function GetShowReport: boolean;
    procedure SetShowReport(AShowReport: boolean);
    function GetShowXY: boolean;
    procedure SetShowXY(AShowXY: boolean);
    function GetMinRecLen: TULRecLen; override;
  public
    constructor Create(AOwner:TULObj);
    function GetULRecDesc: PULRecDesc; override;
  published
    property ShowData: boolean
      read GetShowData write SetShowData;
    property ShowPeaks: boolean
      read GetShowPeaks write SetShowPeaks;
    property ShowAxis: boolean
      read GetShowAxis write SetShowAxis;
    property ShowBaseline: boolean
      read GetShowBaseline write SetShowBaseline;
    property ShowHeader: boolean
      read GetShowHeader write SetShowHeader;
    property ShowReport: boolean
      read GetShowReport write SetShowReport;
    property ShowXY: boolean
      read GetShowXY write SetShowXY;
  end;

const
  ULVOFldDescs: array[0..6] of TULFldDesc = (
    (
     Caption: 'Show data';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 1;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0
    ),
    (
     Caption: 'Show peaks';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 1;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0
    ),
    (
     Caption: 'Show axis';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 1;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0
    ),
    (
     Caption: 'Show baseline';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 1;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0
    ),
    (
     Caption: 'Show header';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 1;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0
    ),
    (
     Caption: 'Show report';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 1;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0
    ),
    (
     Caption: 'Show mouse coordinates';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 1;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0
    )
  );
  ULVORecDesc: TULRecDesc = (
    Caption: 'View options';
    ChildRecIDsStr: '';
    ChildRecIDs: nil;
    ChildRecIDCount: 0;
    FldCount: 7;
    Flds: @ULVOFldDescs;
    Flags: rfEnabled + rfVisible;
    SortExp: '';
    EditFieldList: '';
    BrowseFieldList: ''
   );

implementation

{TULVOObj}
function TULVOObj.GetMinRecLen: TULRecLen;
begin
  GetMinRecLen := sizeof(TULVORec);
end;

constructor TULVOObj.Create(AOwner: TULObj);
begin
  inherited Create(TComponent(AOwner), ULVOID);
  ShowData := true; ShowAxis := true;
end;

function TULVOObj.GetULRecDesc: PULRecDesc;
begin
  Result := @ULVORecDesc;
end;

procedure TULVOObj.SetShowData(AShowData: boolean);
begin
  if PULVORec(Rec)^.ShowData <> AShowData then begin
    PULVORec(Rec)^.ShowData := AShowData;
    DoChange;
  end;
end;

function TULVOObj.GetShowData: boolean;
begin
  GetShowData := PULVORec(Rec)^.ShowData;
end;

procedure TULVOObj.SetShowPeaks(AShowPeaks: boolean);
begin
  if PULVORec(Rec)^.ShowPeaks <> AShowPeaks then begin
    PULVORec(Rec)^.ShowPeaks := AShowPeaks;
    DoChange;
  end;
end;

function TULVOObj.GetShowPeaks: boolean;
begin
  GetShowPeaks := PULVORec(Rec)^.ShowPeaks;
end;

procedure TULVOObj.SetShowAxis(AShowAxis: boolean);
begin
  if PULVORec(Rec)^.ShowAxis <> AShowAxis then begin
    PULVORec(Rec)^.ShowAxis := AShowAxis;
    DoChange;
  end;
end;

function TULVOObj.GetShowAxis: boolean;
begin
  GetShowAxis := PULVORec(Rec)^.ShowAxis;
end;

procedure TULVOObj.SetShowBaseline(AShowBaseline: boolean);
begin
  if PULVORec(Rec)^.ShowBaseline <> AShowBaseline then begin
    PULVORec(Rec)^.ShowBaseline := AShowBaseline;
    DoChange;
  end;
end;

function TULVOObj.GetShowBaseline: boolean;
begin
  GetShowBaseline := PULVORec(Rec)^.ShowBaseline;
end;

procedure TULVOObj.SetShowHeader(AShowHeader: boolean);
begin
  if PULVORec(Rec)^.ShowHeader <> AShowHeader then begin
    PULVORec(Rec)^.ShowHeader := AShowHeader;
    DoChange;
  end;
end;

function TULVOObj.GetShowHeader: boolean;
begin
  GetShowHeader := PULVORec(Rec)^.ShowHeader;
end;

procedure TULVOObj.SetShowReport(AShowReport: boolean);
begin
  if PULVORec(Rec)^.ShowReport <> AShowReport then begin
    PULVORec(Rec)^.ShowReport := AShowReport;
    DoChange;
  end;
end;

function TULVOObj.GetShowReport: boolean;
begin
  GetShowReport := PULVORec(Rec)^.ShowReport;
end;

procedure TULVOObj.SetShowXY(AShowXY: boolean);
begin
  if PULVORec(Rec)^.ShowXY <> AShowXY then begin
    PULVORec(Rec)^.ShowXY := AShowXY;
    DoChange;
  end;
end;

function TULVOObj.GetShowXY: boolean;
begin
  GetShowXY := PULVORec(Rec)^.ShowXY;
end;

{/TULVOObj}

end.
