unit Dbutl;
interface
uses
  SysUtils, Dialogs, DBTables, DBiTypes, DBiProcs, DBiErrs;

function PackTable(var ATable:TTable):boolean;
function ZapTable(var ATable:TTable):boolean;

function SelectIndexName(var ATable:TTable; AIndexName:string):boolean;
{tries to select specified index name; returns false if no such index exists}

implementation

type
  EDBPack = class(Exception);

function PackTable(var ATable:TTable):boolean;
var Error:DBiResult;
begin
  Result := false;
  try
    with ATable do begin
      if TableType = ttDBase then begin
        DisableControls;
        Active := false;
        Exclusive := true;
        Active := true;
        Error := DBiPackTable(DBHandle, Handle, nil, nil, True);
        EnableControls;
        if Error = DBIERR_NONE then begin
          Result := true;
        end else begin
          raise EDBPack.Create('Nelze pakovat tento dBase soubor');
        end;
      end;
    end;
  except
    on E:EDBPack do
      MessageDlg(E.Message, mtError, [mbOK],0);
  end;
end;

function ZapTable(var ATable:TTable):boolean;
begin
  ZapTable := false;
  ATable.DisableControls;
  try
    ATable.IndexName := '';
    ATable.First;
    while not ATable.EOF do begin
      ATable.Delete;
      ATable.First;
    end;
    ZapTable := PackTable(ATable);
  finally
    ATable.EnableControls;
  end;
end;

function SelectIndexName(var ATable:TTable; AIndexName:string):boolean;
begin
  ATable.IndexDefs.Update;
  if ATable.IndexDefs.IndexOf(AIndexName) >= 0 then begin
    ATable.IndexName := AIndexNAme;
    SelectIndexName := true;
  end else
    SelectIndexName := false;
end;
{tries to select specified index name; returns false if no such index exists}

end.
