unit FileType;
{$I define.pas}
interface
uses mytype;
type
  TFileAttr = word;
{faXXXX File Attributes (dos unit)}
const
  faReadOnly      =  $01;
  faHidden        =  $02;
  faSysFile       =  $04;
  faVolumeID      =  $08;
  faDirectory     =  $10;
  faArchive       =  $20 ;
  faAnyFile       =  $3F;
{/faXXXX File Attributes}

type
  TFileMode = word;

{fmXXXX FileMode - file open/sharing modes }
Const {see also stream stXXXX access modes above}
   fmReadOnly  = $00;
   fmWriteOnly = $01;  { Only one of these should be used }
   fmReadWrite = $02;

   {fmAppend = $100;     { only functional in crtu.FOpen }

   fmDenyAll   = $10;  { together With only one of these }
   fmDenyWrite = $20;
   fmDenyRead  = $30;
   fmDenyNone  = $40;

   fmNoInherit = $70;  { Set For "No inheritance" }

  {  FileSHARinG !
     When sharing Files concurrently, by means of For example a multitasker or a
     network, it is necessary to use the File sharing as provided by the Dos
     command SHARE, or as provided by a Network shell (In Novell File sharing is
     supported by the network shell on Servers, not locally. Check your network
     documentation For more inFormation).

     File sharing is simple in TP/BP, since the system Variable FileMode defines
     in what mode a certain File is opened in:
  }

  {
     Construction the FileMode Variable is easy, just add the
     appropriate values:

     FileMode:=fmReadOnly+fmDenyNone;
           (Open File For reading only, allow read and Write.)

     FileMode:=fmReadWrite+fmDenyWrite;
           (Open File For both read and Write, deny Write.)

     FileMode:=fmReadWrite+fmDenyAll;
           (Open File For both read and Write, deny all.)

     Say you open the File in "fmReadWrite+fmDenyWrite". This will let you read
     and Write freely in the File, While other processes can freely read the File.
     if another process tries to open the File For writing, that process will get
     the error "Access denied".

     (fmNoInherit is seldom used - it defines if a childprocess spawn from your
     process will be able to use the Filehandle provided by your process.)

     The FileMode Variable is only used when the File is opened;

      ...
     Assign(F,FileName);
     FileMode:=fmReadOnly+fmDenyNone;
     Reset(F);
     FileMode:=<Whatever>     Changing FileMode here does not affect the
                              Files already opened


     By default, FileMode is defined as FileMode:=$02 in TP/BP, this is referred
     to as "Compatibility mode" in the TP/BP docs. Two processes accessing the
     same File With this Filemode results in the critical error "Sharing
     violation".
     ----------------------------------------------------------------------
}
{/fmXXXX}


const
  TmpExt = '.$$$';
type
  TFileNamePart = word;
  TFileProperty = integer;
{fpXXXX GetFileNamePart, GetFilePropInt, SetFilePropInt }
const
  fpBaseName = 1;
  { Pouvno pro oznaen jmna souboru bez adrese a bez ppony
    ve funkci GetFileNamePart }
  fpExt = 2;
  { Pouvno pro oznaen jmna ppony souboru ve funkci GetFileNamePart }
  fpDir = 3;
  { Pouvno pro oznaen jmna adrese souboru ve funkci GetFileNamePart,
    funkce vrac adres vetn lomtka, pouijte parametr
    (fpDir + fpDelBackSlash) pokud chcete jmno adrese bez lomtka }
  fpDirAndBaseName = 4;
  { Pouvno pro oznaen jmna souboru bez ppony ve funkci GetFileNamePart }
  fpBaseNameAndExt = 5;
  { Pouvno pro oznaen jmna souboru bez adrese ve funkci GetFileNamePart }
  fpUtlFile = 6;
  { Parameter pro funkci GetFileNamePart, funkce pak vrac pln jmno
    souboru, je je hledn v adresch: aktuln, exe, path }
  fpExpand = 7;
  { Parametr pro funkci GetFileNamePart, funkca pak vrac
    stejn vsledek jako Pascalovsk funkce FExpand }
  fpTempFileNameInDir = 8;
  { Parametr pro funkci GetFileNamePart, funkce vrac jmno
    doasnho souboru v adresi AFileName; pokud AFileName = '',
    pak v adresi, kter systm pouv pro doasn soubory;
    soubory maj ppony TmpExt (='.$$$') }
  fpTempFileName = 9;
  { Parametr pro funkci GetFileNamePart (AFileName se ignoruje).
    Vrac jmno doasnho souboru vytvoenho v aktulnm adresi;
    soubory maj ppony TmpExt (='.$$$')}
  fpFileSize = 30;
  { Parametr pro funkci GetFilePropInt, fce vraci velikost
    souboru v bytech }
  fpFileAttr = 31;
  { Parametr pro funkci GetFilePropInt, fce vraci atributy
    souboru (viz DOS konstanty); take SetFilePropInt }
  fpFileTime = 32;
  { Parametr pro funkci GetFilePropInt, fce vraci pakovany
    datum/cas souboru; take SetFilePropInt }
  fpFileExists = 33;
  { Parametr pro funkci GetFilePropInt, fce vraci 1 kdyz
    soubor existuje, 0 pokud ne }
  fpAbsolutePath = 34;
  { Parametr pro funkci GetFilePropInt, fce vraci 1 kdyz
    jmenou souboru obsahuje absolutn cestu (adrese ponaje
    hlavnm) existuje, 0 pokud ne }
  {v2.09}
  fpShortName = 35;
    { For GetFileNamePart, for Win95 returns shortname otherwise
      returns the AFileName }
  {/v2.09}
  {v2.10}
  fpIsDiskReady = 36;
    { GetFilePropInt returns > 0 if disk that is the file on is
      ready (floppy) }
  {/v2.10}



  fpAddBackSlash = $100;
  { Pouvno pro pipojen (i kontrolu pipojen) zptnho lomtka
    na konec jmna adrese ve funkci GetFileNamePart }
  fpDelBackSlash = $200;
  { Pouvno pro odstrann (i kontrolu odstrann) zptnho
    lomtka na konci jmna adrese ve funkci GetFileNamePart }
{/fpXXXX}

type
  TFileResult = integer;

{frXXXX results of file related methods - SetFilePropInt }
const
  frOK = 0;
  fr0 = 9000;
  frInvalidGetProp = fr0 + 1;
  frInvalidSetProp = fr0 + 2;
  {dofiles:}
  frBadSourceDir = fr0 + 100;
  frCantCreateDir = fr0 + 102;
  frSameTargetDir = fr0 + 103;
  frCantCopy = fr0 + 104;
  frCantErase = fr0 + 105;
  frEOF = fr0 + 106;
  {/dofiles}
  {plus dos file error constants}

{/frXXXX}
{drXXXX DirDo method results}
const
  drOK = 0;
  dr0 = 700;
  drInvalidDirAction = dr0 + 1;
  drDirNotFound = dr0 + 2;
  drCouldNotEraseFiles = dr0 + 3;
  drDiskNotReady = dr0 + 4;
{/drXXXX}

type
  TDirAction = integer;
  TDirResult = TFileResult;
{daXXXX Dir Actions; parameters for DirDo method}
const
  da0 = 800;
  daDirExists = da0 + 1;
  daDirDelete = da0 + 2;
  daDirCreate = da0 + 3;
  daDirGetCurrent = da0 + 4;
  daDirSetCurrent = da0 + 5;
{/daXXXX}


{dofileu related constants and types }
type
  TFilesDoAction = char; { see dfXXXX }
  TFilesDoOptions = longint; { see foXXXX }
  TFilesDoResult = TFileResult; { see common frXXXX section above }
{dfXXXX FilesDo Actions:}
const
  dfList = 'l';
  dfDelete = 'd';
  dfCompare = 'c';
  dfCopy = 'p';
  dfMove = 'm';
  dfUpdate= 'u';
  dfSynchronize = 's';
  dfSearchduplicates = 't';

  DoFileActions = [dfList, dfDelete, dfCompare, dfCopy,
    dfMove, dfUpdate, dfSynchronize, dfSearchDuplicates];
{/dfXXXX}

const
  MaxDoFileOptions = 6;

  oiVerbose = 2;
  oiDontConfirm = 3;
  oiRecursive = 4;
  oiStartTime = 5;
  oiStopTime = 6;

{foXXXX TFilesDoOptions for FilesDo method }
const
  foDefault = 0;
  foRecursive = 1;
    { Do action with files recursively }
  foVerbose = 2;
    { Show progress of the action for each file }
  foDontAsk = 4;
    { Dont ask for overwriting existing files (ignored anyway) }
{/foXXXX}

{/dofileu}

implementation
end.