unit Showmsg;
interface
uses WinTypes, WinProcs, Forms, SysUtils, Controls, MyType, TVType;

const
{  smError = 1;
  smInfo = 2;
  smYesNo = 3;
  smNoYes = 4;}
  smShowMessageCounter = 5;

function ShowMessage(msg:string; what:longint; hc:word):word;
procedure SysError(msg:string);


implementation
const
  ShowMessageCounter :word = 0;

function ShowMessage(msg:string; what:longint; hc:word):word;
var
  title:string;
  t,p:array[0..255]of char;
  flags:longint;
  r:integer;
begin
  if what <> smShowMessageCounter then begin
    title := '';
    flags := 0;
    case what of
      smError: begin
        title := 'Error';
        flags := MB_OK + MB_ICONEXCLAMATION;
      end;
      smYesNo: begin
        title := 'Confirmation';
        flags := MB_YESNO + MB_ICONQUESTION;
      end;
      smNoYes: begin
        title := 'Confirmation';
        flags := MB_YESNO + MB_ICONQUESTION + MB_DEFBUTTON2;{messagbox}
      end;
      smInfo: begin
        title := 'Info';
        flags := MB_ICONINFORMATION + MB_OK;
      end;
      smYesNoCancel: begin
        title := 'Confirmation';
        flags := MB_ICONQUESTION + MB_YESNOCANCEL;
      end;
      smFileModifiedSave: begin
        if msg = '' then
          msg := 'File modified. Save changes?'
        else
          msg := msg + ' modified. Save changes?';
        title := 'Confirmation';
        flags := MB_ICONQUESTION + MB_YESNOCANCEL;
      end;
    end;
    inc(ShowMessageCounter);
    r := Application.MessageBox(StrPCopy(p, msg), StrPCopy(t, title), flags);
    case r of
      mrOK: r := cmOK;
      mrYes : r := cmYes;
      mrNo : r := cmNo;
      mrCancel: r := cmCancel;
    end;
    ShowMessage := r;
    dec(ShowMessageCounter);
  end else begin
    ShowMessage := ShowMessageCounter;
  end;
end;

procedure SysError(msg:string);
begin
  ShowMessage(msg, smError,0);
end;

end.
