unit ulmtype;
{ .ULM method record/file format description }
interface

uses
  UlanType, ULRecTyp;{ULREC.LST}

const
  ULMID = ord('U') + 256*ord('L') + 256*256*ord('M');

type
  TULMRec = packed record {<Caption="Method" ChildRecIDs=ULBID,ULMFID,ULPID
    RootChild=1 Uses=ULBType,ULMFType,ULPType Enabled=1 Visible=1
    Create1="BaseMinInterval := 30;" Create2="BaseMaxDiff := 5e-5;"
    Create3="MinPeakWidth := 12;" Create4="MinPeakHeight := 0.01;">}
    Head: TULRecHead;
    Info: TULRecInfo;
    MethodTemplate: TULFileName;{<Enabled=1 ReadOnly=1 Caption="Method template"
      Type=FileName>}
      { What method file was used as a template for creation of this method
        object (='' if none) }
    CalibrationFileName: TULFileName;{<Enabled=1 ReadOnly=1 Caption="Calibration file"
      Type=FileName>}
      { What calibration file is used for calculation of peak.amounts }
    MethodFileName: TULFileName;{<Enabled=1 ReadOnly=1 Visible=0 Type=FileName>}
      { (Was DataFileName) Name of the file where the method was saved to.
        Usually non empty only if method was loaded from template, modified
        and saved as new method template. }
    Dilution: TDilution;{<Enabled=0 Visible=0>}
    BaseMinInterval: single;{<Enabled=1 UserCoef=60 NumDec=2 Caption="Base.min.interval [min]"
      Hint="What is the minimal width of baseline section that should be autodetected">}
    BaseMaxDiff: single;{<Enabled=1>}
      { Maximal abs.value of the second order derivative of the baseline that should
        be autodetected. }
    MinPeakHeight: single;{<Enabled=1 Caption="Min. peak height"
      Hint="What it the minimal height of the peak that should be autodetected">}
    MinPeakWidth: single;{<Enabled=1 UserCoef=60 NumDec=2 Caption="Min. peak width [min]"
      Hint="What is the minimal width of peak that should be autodetected">}
      { Used in autodetection (minimal width of the peak) and also as default
        Window value for those method or calibration peaks, that have no
        Window value assigned. }
    UseNegativePeaks: boolean;{<Enabled=1>}
    CalcAmounts: boolean;{<Enabled=1 Hint="Should peak amounts be calculated?">}
      { Do the calculation of peak amounts after autodetection
        or upon user request (show recalculate menu item), using
        either calibration file (if UseCalibrationFile set) or
        internal standard (if UseInternalStandard set), or both (if both set)? }
    UseCalibrationFile: boolean;{<Enabled=1 Hint="Should peak amounts be calculated using calibration file?">}
      { Use the file specified in CalibrationFileName field as calibration
        file for calculation of peak.amounts? }
    UseInternalStandard: boolean;{<Enabled=1 Hint="Should peak amounts be calculated using internal standard?">}
      { Use the peak which InternalStandard field is set true for calculation
        of peak.amounts? }
    Factor: TFactor;{<Enabled=1>}
      { Coefficient used for calibration calculations, used to multiply
        calibration results for all peaks. Set automatically to 1 during
        ResponsesCalculate, if left 0. }
    CalibrationFileAge: integer;{<Enabled=0 Visible=0 Type=FileDateTime>}
      { Age of the calibration file at the time when it was loaded
        to memory }
  end;
  PULMRec = ^TULMRec;

implementation

end.
