unit AnalSetupFrm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  uledfrm, StdCtrls, ComCtrls, ExtCtrls,
  ULRecTyp, ULObju, ULMType, ULIType, ULEdUtl{v0.14}, ExtComDl
  , Spectrum, UlanType, UlanGlob{/v0.14}{v0.15}, MyType, TVType, ShowMsg{/v0.15};

type
  TAnalSetupForm = class(TULEditForm)
    Panel1: TPanel;
    PageControl: TPageControl;
    ULATabSheet: TTabSheet;
    Panel4: TPanel;
    Label1: TLabel;
    SampleDescLabel: TLabel;
    AmountLabel: TLabel;
    ISTDAmountLabel: TLabel;
    InjectionVolumeLabel: TLabel;
    SampleNameEdit: TEdit;
    SampleDescEdit: TMemo;
    AmountEdit: TEdit;
    ISTDAmountEdit: TEdit;
    InjectionVolumeEdit: TEdit;
    CalibrationStandardEdit: TCheckBox;
    ULMTabSheet: TTabSheet;
    ULITabSheet: TTabSheet;
    Panel2: TPanel;
    OKBtn: TButton;
    CancelBtn: TButton;
    HelpBtn: TButton;
    MethodTemplateEdit: TEdit;
    CalibrationFileNameEdit: TEdit;
    MethodFileNameEdit: TEdit;
    DilutionLbl: TLabel;
    DilutionEdit: TEdit;
    BaseMinIntervalEdit: TEdit;
    BaseMinIntervalLbl: TLabel;
    BaseMaxDiffLbl: TLabel;
    BaseMaxDiffEdit: TEdit;
    MinPeakHeightEdit: TEdit;
    MinPeakHeightLbl: TLabel;
    MinPeakWidthLbl: TLabel;
    MinPeakWidthEdit: TEdit;
    UseNegativePeaksLbl: TLabel;
    UseNegativePeaksEdit: TCheckBox;
    CalcAmountsLbl: TLabel;
    CalcAmountsEdit: TCheckBox;
    UseCalibrationFileEdit: TCheckBox;
    UseCalibrationFileLbl: TLabel;
    UseInternalStandardLbl: TLabel;
    UseInternalStandardEdit: TCheckBox;
    FactorLbl: TLabel;
    FactorEdit: TEdit;
    CalibrationFileAgeEdit: TEdit;
    CalibrationFileAgeLbl: TLabel;
    ColumnEdit: TEdit;
    ColumnLbl: TLabel;
    MobilePhaseLbl: TLabel;
    MobilePhaseEdit: TEdit;
    FlowRateUnitEdit: TComboBox;
    FlowRateLbl: TLabel;
    FlowRateEdit: TEdit;
    DetectionEdit: TEdit;
    FlowRateUnitLbl: TLabel;
    DetectionLbl: TLabel;
    TemperatureLbl: TLabel;
    TemperatureEdit: TEdit;
    TemperatureUnitEdit: TComboBox;
    TemperatureUnitLbl: TLabel;
    MethodOpenDialog: TOpenDialog;
    MethodSaveDialog: TSaveDialog;
    CalibrationFileSelectDialog: TOpenDialog;
    MethodFilePanel: TPanel;
    MethodLoadFromBtn: TButton;
    MethodSaveToBtn: TButton;
    CalibrationFileBtn: TButton;
    InstrumentFilePanel: TPanel;
    InstrumentTemplateEdit: TEdit;
    InstrumentSaveDialog: TESaveDialog;
    InstrumentOpenDialog: TEOpenDialog;
    InstrumentFileNameEdit: TEdit;
    InstrumentLoadFromBtn: TButton;
    InstrumentSaveToBtn: TButton;
    ParametersBtn: TButton;
    ChannelNameEdit: TComboBox;
    Label2: TLabel;
    FileNameEdit: TEdit;
    FileNameLbl: TLabel;
    DurationEdit: TEdit;
    DurationLbl: TLabel;
    SamplingIntervalEdit: TEdit;
    Label3: TLabel;
    procedure OKBtnClick(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
    procedure MethodLoadFromBtnClick(Sender: TObject);
    procedure MethodSaveToBtnClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure ParametersBtnClick(Sender: TObject);
    procedure CalibrationFileBtnClick(Sender: TObject);
    procedure InstrumentLoadFromBtnClick(Sender: TObject);
    procedure InstrumentSaveToBtnClick(Sender: TObject);
  private
    { Private declarations }
    {v0.15}
    FFileName: TFileName;
    {/v0.15}
  protected
    Data: TAcqData;
    procedure ComponentsToObj; override;
      { Copy values of visual edit components to properties of Obj TULObj }
    procedure ObjToComponents; override;
      { Copy values of properties of Obj TULObj to visual edit components }
  public
    { Public declarations }
    {v1.14}
    constructor Create(AOwner: TComponent); reintroduce;
    {/v1.14}
  end;

var
  AnalSetupForm: TAnalSetupForm;

implementation

{$R *.DFM}

procedure TAnalSetupForm.ComponentsToObj;
 { Copy values of visual edit components to properties of Obj TULObj }
var
  m, i: TULObj;
begin
  inherited;
  if Obj.FindObj(ULMID, 0, '', m) then
    FormToULObj(Self, m, [], FObjRootFileDir);
  if Obj.FindObj(ULIID, 0, '', i) then
    FormToULObj(Self, i, [], FObjRootFileDir);
end;

procedure TAnalSetupForm.ObjToComponents;
 { Copy values of properties of Obj TULObj to visual edit components }
var
  m, i: TULObj;
begin
  inherited;
  if Obj.FindObj(ULMID, 0, '', m) then
    ULObjToForm(m, Self, [], FObjRootFileDir);
  if Obj.FindObj(ULIID, 0, '', i) then
    ULObjToForm(i, Self, [], FObjRootFileDir);
  {v0.15}
  FileNameEdit.Visible := pos('NONAME', Data.ULF.FileName) > 0;
  FileNameLbl.Visible := FileNameEdit.Visible;
  {/v0.15}
end;

procedure TAnalSetupForm.OKBtnClick(Sender: TObject);
begin
  inherited;
  {v0.15}
  if FileNameEdit.Visible then begin
    {v0.17} {ulantype}
    FFileName := FileNameEdit.Text;
    {/v0.17}
    if trim(FFileName) <> '' then begin
      FFileName := ChangeFileExt(DataDir + ExtractFileName(FileNameEdit.Text), ULFExt);
      if FileExists(FFileName) then begin
        if ShowMessage('File ' + FFileName + ' Exists. Overwrite?', smNoYes, 0) <> cmYes then begin
          ModalResult := 0;
          PageControl.ActivePage := ULATabSheet;
          FileNameEdit.SetFocus;
          exit;
        end;
      end;
      Data.ULF.FileName := FFileName;
    end;
  end;
  {/v0.15}
  DoOnOK;
end;

procedure TAnalSetupForm.CancelBtnClick(Sender: TObject);
begin
  inherited;
  DoOnCancel;
end;

procedure TAnalSetupForm.MethodLoadFromBtnClick(Sender: TObject);
begin
  inherited;
  {v0.14}
  if Data.ULM.MethodTemplate <> '' then
    MethodOpenDialog.FileName := Data.ULM.MethodTemplate;
  if MethodOpenDialog.Execute then begin
    Data.MethodLoadFromFile(MethodOpenDialog.FileName);
    ULObjToForm(Data.ULM, Self, {v0.15}[]{/v0.15 [foOnlyFileNames]}, FObjRootFileDir);
{    MethodTemplateEdit.Text := RelativeFileName(FStartDir, Data.ULM.MethodTemplate);}
  end;
  {/v0.14}
end;

procedure TAnalSetupForm.MethodSaveToBtnClick(Sender: TObject);
begin
  inherited;
  {v0.14}
  if Data.ULM.MethodFileName <>  '' then
    MethodSaveDialog.FileName := Data.ULM.MethodFileName;
  if MethodSaveDialog.Execute then begin
    Data.MethodSaveToFile(MethodSaveDialog.FileName);
    ULObjToForm(Data.ULM, Self, [foOnlyFileNames], FObjRootFileDir);
{    MethodFileNameEdit.Text := RelativeFileName(FStartDir, Data.ULM.MethodFileName);}
  end;
  {/v0.14}
end;

{v0.14}
constructor TAnalSetupForm.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Data := TAcqData(Obj.MainUser);
end;
{/v0.14}

procedure TAnalSetupForm.FormActivate(Sender: TObject);
begin
  inherited;
  ParametersBtn.Visible := UserMode = umSysOp;
  {v0.15}
  if Data.ULI.IsFlagSet(rfWriteLocked) then begin
    InstrumentLoadFromBtn.Enabled := false;
  end;

  {/v0.15}
end;

procedure TAnalSetupForm.ParametersBtnClick(Sender: TObject);
begin
  inherited;
  Obj.Browse;
end;

{v0.14}
procedure TAnalSetupForm.CalibrationFileBtnClick(Sender: TObject);
var fn:string;
begin
  inherited;
  fn := Data.ULM.CalibrationFileName;
  if fn <> '' then
    CalibrationFileSelectDialog.FileName := fn;
  if CalibrationFileSelectDialog.Execute then begin
    Data.CalibrationFileSelect(CalibrationFileSelectDialog.FileName);
    ULObjToForm(Data.ULM, Self, [foOnlyFileNames], FObjRootFileDir);
    if Data.Spectrum = nil then
      exit;
    Data.Spectrum.PeaksAmountsCalculateCalibrationFile;
  end;
end;
{/v0.14}

procedure TAnalSetupForm.InstrumentLoadFromBtnClick(Sender: TObject);
var s:string;
begin
  inherited;
  {v0.14}
  GetDir(0, s);
  InstrumentOpenDialog.InitialDir := s;
  if Data.ULI.InstrumentTemplate <> '' then
    InstrumentOpenDialog.FileName := Data.ULI.InstrumentTemplate;
  if InstrumentOpenDialog.Execute then begin
    Data.InstrumentLoadFromFile(InstrumentOpenDialog.FileName);
    ULObjToForm(Data.ULI, Self, {v0.15}[]{/v0.15 [foOnlyFileNames]}, FObjRootFileDir);
{    InstrumentTemplateEdit.Text := RelativeFileName(FStartDir, Data.ULI.InstrumentTemplate);}
  end;
  {/v0.14}
end;

procedure TAnalSetupForm.InstrumentSaveToBtnClick(Sender: TObject);
var s: string;
begin
  inherited;
  {v0.14}
  GetDir(0, s);
  InstrumentSaveDialog.InitialDir := s;
  if Data.ULI.InstrumentFileName <>  '' then
    InstrumentSaveDialog.FileName := Data.ULI.InstrumentFileName;
  if InstrumentSaveDialog.Execute then begin
    Data.InstrumentSaveToFile(InstrumentSaveDialog.FileName);
    ULObjToForm(Data.ULI, Self, [foOnlyFileNames], FObjRootFileDir);
  end;
  {/v0.14}
end;

end.
