program convdata;
uses
  SysUtils, 
  CmdLine,
  ExpImpu;

const
  ConvOptionCount = 2;
  
  ConvOptions: array[1..ConvOptionCount] of TOptionRec = (
    (OptionName:'i'; OptionDesc:nil; Flag:0;Present:false; Option: otString; Param: ''),
    (OptionName:'o'; OptionDesc:nil; Flag:0;Present:false; Option: otString; Param: '')
  );

var
  i: integer;
  s, inf, outf: string;
begin
  if paramcount = 0 then begin
    Writeln('Usage: convdata [-iFormatName] [-oFormatName] InFileName [OutFileName[.DAT]]');
    Writeln('Converts acquisition data contained in InFileName file to ');
    writeln('ChromuLan raw data file (.DAT) or to format specified by ');
    writeln('-o options. Using format definitions in ULE.ASC config. file.');
    writeln('FormatName is usually just file extension, if longer then 3 chars,');
    writeln('then definition name is looked up (instead of extension name) in ULE.ULE');
  end else begin

    if ProcessCommandLine(@ConvOptions, ConvOptionCount) then begin
      inf := '';
      outf := '';
      for i := 1 to paramcount do begin
        s := paramstr(i);
        if (s <> '') and (s[1] <> '-') then begin
          if inf = '' then
            inf := s
          else if outf = '' then
            outf := s;
        end;
      end;

      if inf = '' then begin
        writeln('No input file specified.');
      end else begin
        try
          ConvertDataFile(inf, ConvOptions[1].Param, outf, ConvOptions[2].Param);
          writeln('Conversion succeeded.');
        except
          on E:Exception do
            writeln('Conversion failed. ' + E.Message);
        end;
      end;
    end else begin
      writeln('Ivalid command line parameters.');
    end;
    writeln;
  end;
end.
