unit testfrm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, timer;

type
  TTestForm2 = class(TForm)
    TestStreamButton: TButton;
    ResultEdit: TEdit;
    procedure TestStreamButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  TestForm2: TTestForm2;

implementation

{$R *.DFM}

procedure TTestForm2.TestStreamButtonClick(Sender: TObject);
var
  s:TMemoryStream;
  v, l:longint;
  starttime, writetime, streamtime, memtime:longint;
  cr:TCursor;
  size:longint;
const
  testcount = 1000000;
begin
  cr := Screen.Cursor;
  Screen.Cursor := crHourGlass;
  try

  s := TMemoryStream.Create;
  v := 0;
  starttime := mstime;
  for l := 0 to testcount - 1 do begin
    s.WriteBuffer(v, sizeof(v));
  end;
  writetime := mstime - starttime;

  s.Position := 0;
  starttime := mstime;
  for l := 0 to testcount - 1 do begin
    s.ReadBuffer(v, sizeof(v));
  end;
  streamtime := mstime - starttime;
  starttime := mstime;
  size := s.Size;
  for l := 0 to testcount - 1 do begin {tmemorystream}
    if l + sizeof(v) < size then begin
      if s is TMemoryStream then
        v := PByteArray(s.Memory)^[l * sizeof(v)];
    end;
  end;
  memtime := mstime - starttime;
  ResultEdit.Text := IntToStr(writetime) + ' ' + IntToStr(streamtime) + ' ' + IntToStr(memtime);
  finally
    Screen.Cursor := cr;
  end;
end;

end.
