unit ulmain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls,
  ULDrvTyp, ULDrvUtl, ULDriver, ModuType, Modulu,
  UlanType, UlanGlob,
  ulmaglob, ul_lcabs, Buttons;

type
  TulMasterForm = class(TForm)
    ModulesListBox: TListBox;
    Timer: TTimer;
    ScanBtn: TButton;
    TestBtn: TButton;
    Image1: TImage;
    Button1: TButton;
    procedure ScanBtnClick(Sender: TObject);
    procedure ModulesListBoxDblClick(Sender: TObject);
    procedure TimerTimer(Sender: TObject);
    procedure TestBtnClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
    FScanned:boolean;
  public
    { Public declarations }
    function GetCurrentModule:TModule;
    procedure ScanForModules;
  end;

var
  ulMasterForm: TulMasterForm;

implementation
uses modfrm;
{$R *.DFM}

procedure TulMasterForm.ScanBtnClick(Sender: TObject);
begin
  ScanForModules;
end;

procedure TULMasterForm.ScanForModules;
var sl:TStringList;
begin
  FScanned := true;
  if (Modules.ScannedForModules and (Modules.Count > 0))
    or (Modules.ScanForModules > 0) then
  begin
    sl := TStringList.Create;
    if Modules.GetModulesList(sl) then begin
      ModulesListBox.Items := sl;
    end;
    sl.Free;
  end;
end;


function TulMasterForm.GetCurrentModule:TModule;
var
  i,ad:integer;
  m:TModule;
begin
  GetCurrentModule := NoModule;
  i := ModulesListBox.ItemIndex;
  if (i < 0) or (i >= ModulesListBox.Items.Count) then
    exit;
  ad := StrToInt(copy(ModulesListBox.Items[i],1, ModuleAddrStrLen));
  if not Modules.FindModule(ad, m) then
    exit;
  GetCurrentModule := m;
end;

procedure TulMasterForm.ModulesListBoxDblClick(Sender: TObject);
begin
  CurModule := GetCurrentModule;
  ModuleFormShowCurrent;
end;

procedure TulMasterForm.TimerTimer(Sender: TObject);
begin
  ulMDoTimer;
  if not FScanned then
    ScanForModules;
end;

procedure TulMasterForm.TestBtnClick(Sender: TObject);
begin
  Modules.ULD.Browse;
end;

procedure TulMasterForm.Button1Click(Sender: TObject);
begin
  Modules.SendGetPropVals;
end;

end.
