unit AAAlarmFrm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Timer, Timersu;

type
  TAAFatalForm = class(TForm)
    lbl: TLabel;
    NoBtn: TButton;
    YesBtn: TButton;
    procedure NoBtnClick(Sender: TObject);
    procedure YesBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
    FStartTime: integer;
  public
    { Public declarations }
    procedure DoTimer(Sender: TObject);
  end;

implementation
uses
  AAAu;
{$R *.DFM}

procedure TAAFatalForm.NoBtnClick(Sender: TObject);
begin
  AAA.FatalCanceled;
  Release;
end;

procedure TAAFatalForm.YesBtnClick(Sender: TObject);
begin
  AAA.FatalConfirmed;
  Release;
end;

procedure TAAFatalForm.FormCreate(Sender: TObject);
begin
  FStartTime := mstime;
  Timers.AddTimerProc(DoTimer, 1000);
end;

procedure TAAFatalForm.DoTimer(Sender: TObject);
begin
  if (mstime - FStartTime) > 20 * 1000 then begin
    AAA.FatalConfirmed;
    Release;
  end else begin
    BringToFront;
  end;
end;

procedure TAAFatalForm.FormDestroy(Sender: TObject);
begin
  Timers.DeleteTimerProc(DoTimer);
end;

end.
