unit ChkULFu;
interface
uses

  ULRecTyp, ULObju, UlanType, Spectrum;

procedure ChkDataFile(const AFileName: string; fix: boolean);

function ChkAcqData(a: TAcqData; fix: boolean): boolean;
  { returns false if error found }

implementation

function ChkAcqData(a: TAcqData; fix: boolean): boolean;
var
  di: integer;
  urc: TULADRc;
  p, lp: TExpPoint;
  reported:boolean;
  s: string;
  usualDif, erdif: TXValue;
begin
  Result := true;
  with a do
  for di := 0 to DataCount - 1 do begin
    DataIndex := di;
    lp.X := -1;
    reported:= false;
    usualDif := 0;
    erDif := 0;

    while ReadPoint(p) do begin

      if usualdif <> 0 then begin

        if abs(p.X - lp.X) > 2 * usualdif then begin

          if erdif = 0 then begin
            Result := false;
            erdif := lp.X - p.X;
            {$IFDEF CONSOLE}
            if not reported then begin
              reported := true;
              s := 'Data file time mismatch error found.';
              if fix then
                s := s + ' Fixing.'
              else
                s := s + ' Not fixing - use "ChkULF -f FileName"';
              writeln(s);
            end;
            {$ENDIF}
          end;

          p.X := lp.X + usualdif;

          if fix then begin
            SeekPoint(-1);
            WritePoint(p);
          end;
        end;

      end else begin

        if usualdif = 0 then begin
          if lp.X >= 0 then
            usualdif := p.X - lp.X;
        end;

      end;

      lp := p;
    end;
    Reset;
  end;
end;
procedure ChkDataFile(const AFileName: string; fix: boolean);
var
  a: TAcqData;
begin
  a := TAcqData.Create(AFileName, omRead);
  try
    ChkAcqData(a, fix);
  finally
    a.Free;
  end;
end;

end.
