unit DevSetFr;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Spin, PBSpinEdit, PBBinHexEdit{v0.11},ExtDevIntu,
  UlDrvUtl, Modulu{/v0.11}{v0.14},ULDriver{/v0.14}{v0.22},ULRecTyp, ULObju{/v0.22}
  {v0.28},Language, FileScanner{/v0.28};

type
  TDevSetupForm = class(TForm)
    OKBtn: TButton;
    CancelBtn: TButton;
    DeviceModeGrpBox: TGroupBox;
    UlanRadioBtn: TRadioButton;
    ApexRadioBtn: TRadioButton;
    ExternalRadioBtn: TRadioButton;
    SysOpCheckBox: TCheckBox;
    PortNamePanel: TPanel;
    PortNameEdit: TEdit;
    PortNameLabel: TLabel;
    UlanPanel: TPanel;
    PortAddrEdit: TPBBinHexEdit;
    Label1: TLabel;
    PortIrqEdit: TPBSpinEdit;
    IrqLabel: TLabel;
    AutoConfigCheckBox: TCheckBox;
    MaxWindowCountEdit: TSpinEdit;
    MaxChromWindowLabel: TLabel;
    UlanBaudRateLabel: TLabel;
    UlanBaudRateComboBox: TComboBox;
    DefAppComboBox: TComboBox;
    DefAppLbl: TLabel;
    LanguageLabel: TLabel;
    LanguageCheckBox: TCheckBox;
    LanguageComboBox: TComboBox;
    AutoFixDataCheckBox: TCheckBox;
    procedure OKBtnClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure ApexRadioBtnClick(Sender: TObject);
    procedure UlanRadioBtnClick(Sender: TObject);
    procedure ExternalRadioBtnClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
    PresentInRegistry: boolean;
      { .. entry for ul_drv.sys? }
    procedure DecideWhatToSee;
    procedure LanguageCheck;
  public
    { Public declarations }
  end;

var
  DevSetupForm: TDevSetupForm;

implementation
uses ulantype, ulanglob;

{$R *.DFM}

procedure TDevSetupForm.OKBtnClick(Sender: TObject);
var
  chn:boolean;
{v0.21}
  br: integer;
{/v0.21}
begin
  if UlanRadioBtn.Checked then begin
    CurDeviceMode := dmUlan;
    {v0.23}
    Modules.DeviceMode := CurDeviceMode;
    {/v0.23}
    {v0.11}
    Modules.ULDrvFailed := false;
    {/v0.11}
  end else if ApexRadioBtn.Checked then
    CurDeviceMode := dmPasive
  else if ExternalRadioBtn.Checked then
    CurDeviceMode := dmExtDev;
  CurPortName := PortNameEdit.Text;
  if SysOpCheckBox.Checked then
    UserMode := umSysOp
  else
    UserMode := umUser;
  {v0.14}
  chn := false;
  if PortAddr <> PortAddrEdit.AsInteger then begin
    PortAddr := PortAddrEdit.AsInteger;
    chn := true;
  end;
  if PortIrq  <> PortIrqEdit.Value then begin
    PortIrq := PortIrqEdit.Value;
    chn := true;
  end;
  {/v0.14
  PortAddr := PortAddrEdit.AsInteger;
  PortIrq := PortIrqEdit.Value;}

  {v0.21}
   br := StrToInt(UlanBaudRateComboBox.Text);
   if br <> UlanBaudRate then begin
     UlanBaudRate := br;
     chn := true;
   end;
  {/v0.21}

  {v0.11}
  if {v0.14}chn {/v0.14 CurDeviceMode = dmUlan} {v0.21} or (not PresentInRegistry) {/v0.21}then
  begin
    ULDrvReqReadWrite(false, PortAddr, PortIrq, PCUlanAddr
     {v0.21}, UlanBaudRate{/v0.21});
  end;
  {/v0.11}
  AutoConfigDriver := AutoConfigCheckBox.Checked;
  {v0.18}
  MaxSpectrumFormCount := MaxWindowCountEdit.Value;
  {/v0.18}
  {v0.24}
  DefaultApplication := DefAppComboBox.Text;
  {/v0.24}
  {v0.28}
  {
  if LanguageCheckBox.Checked then begin
    LanguageInit(LanguageComboBox.Text);
    UseLanguage := true;
  end else begin
    LanguageDone;
    UseLanguage := false;
  end;}
  {/v0.28}
  {v0.45}
  AutofixData := AutofixDataCheckBox.Checked;
  {/v0.45}
end;

procedure TDevSetupForm.FormActivate(Sender: TObject);
{v0.14}
var d: TULDriver;
{/v0.14}
{v0.21}
var
  i: integer;
{/v0.21}
begin
  {v0.21}
  PresentInRegistry := false;
  {/v0.21
  DecideWhatToSee;}

  UlanRadioBtn.Enabled := (OSVersion.dwPlatformId = VER_PLATFORM_WIN32_NT);

  {v0.21}DecideWhatToSee;{/v0.21}

  if (not UlanRadioBtn.Enabled) and (CurDeviceMode = dmUlan) then
    CurDeviceMode := dmUnspecified;

  case CurDeviceMode of
    dmUlan: UlanRadioBtn.Checked := true;
    dmPasive: ApexRadioBtn.Checked := true;
    dmExtDev: ExternalRadioBtn.Checked := true;
  else
    ApexRadioBtn.Checked := true;
  end;
  SysOpCheckBox.Checked := (UserMode = umSysOp);
  PortNameEdit.Text := CurPortName;
  {v0.14}
  d := Modules.ULDrv;
  if d <> nil then begin
    PortAddr := d.PortAddr;
    PortIrq := d.PortIrq;
    {v0.21}
    PresentInRegistry := true;
    UlanBaudRate := d.BaudRate;
    {/v0.21}
    {PCUlanAddr := d.PCUlanAddr;}

  end else
  {/v0.14}
  begin
    {v0.11}
    {v0.21}
    if UlanRadioBtn.Enabled then
    {/v0.21}
    begin
      {v0.21}
      PresentInRegistry :=
        ULDrvReqReadWrite(true, PortAddr, PortIrq, PCUlanAddr,
          UlanBaudRate) = 0;
     {/v0.21
      ULDrvReqReadWrite(true, PortAddr, PortIrq, PCUlanAddr);
     }
    end;
    {/v0.11}
  end;
  PortAddrEdit.AsInteger := PortAddr;
  PortIrqEdit.Value := PortIrq;
  AutoConfigCheckBox.Checked := AutoConfigDriver;
  {v0.18}
  MaxWindowCountEdit.Value := MaxSpectrumFormCount;
  {/v0.18}

  {v0.21}
  UlanBaudRateComboBox.ItemIndex := 3;
  for i := 0 to UlanBaudRateComboBox.Items.Count - 1 do begin
    if StrToInt(UlanBaudRateComboBox.Items[i]) = UlanBaudRate then begin
     UlanBaudRateComboBox.ItemIndex := i;
     break;
    end;
  end;        {winutl}
  {/v0.21}
  {v0.24}
  DefAppComboBox.ItemIndex := DefAppComboBox.Items.IndexOf(DefaultApplication);
  {/v0.24}
  {v0.45}
  AutofixDataCheckbox.Checked := AutofixData;
  {/v0.45}
end;

procedure TDevSetupForm.LanguageCheck;
var
  f: TFileScanner;
  i: integer;
begin
  exit;
  f := TFileScanner.Create(nil);
  try
    f.Dir := ExtractFileDir(Application.ExeName);
    f.Mask := '*.lng';
    f.MakeList := true;
    f.ListFileNameParts := [fpName];
    f.Scan;
    LanguageCheckBox.Checked := FLanguage <> nil;
    LanguageComboBox.Items.Assign(f.List);
    for i := 0 to LanguageComboBox.Items.Count - 1 do begin
      if Uppercase(LanguageComboBox.Items[i]) = Uppercase(FLanguage.LanguageName) then begin
        LanguageComboBox.ItemIndex := i;
        break;
      end;
    end;        {winutl ulanglob}

    {if f.List.Count > 0 then begin
      LanguageLabel.Visible := true;
      LanguageCheckBox.Visible := true;
      LanguageComboBox.Visible := true;
    end else begin
      LanguageLabel.Visible := false;
      LanguageCheckBox.Visible := false;
      LanguageComboBox.Visible := false;
    end;}
  finally
    f.Free;
  end;
end;

procedure TDevSetupForm.DecideWhatToSee;
begin
  if UlanRadioBtn.Checked then begin
    UlanPanel.Visible := true;
    PortNamePanel.Visible := false;
  end else begin
    UlanPanel.Visible := false;
    PortNamePanel.Visible := true;
  end;
  {v0.11}
  {v0.14}
  {/v0.14
  ExternalRadioBtn.Visible := ExtDevPresent('');}
  {/v0.11}
  {v0.40}
  ExternalRadioBtn.Visible := (ExtDevs <> nil) and (ExtDevs.Count > 0);
  {/v0.40}
end;

procedure TDevSetupForm.ApexRadioBtnClick(Sender: TObject);
begin
  DecideWhatToSee;
end;

procedure TDevSetupForm.UlanRadioBtnClick(Sender: TObject);
begin
  DecideWhatToSee;
end;

procedure TDevSetupForm.ExternalRadioBtnClick(Sender: TObject);
begin
  DecideWhatToSee;
end;

procedure TDevSetupForm.FormShow(Sender: TObject);
begin
  {v0.28}
  LanguageCheck;{ulanglob ulatype ulsrtype}
  {/v0.28}
end;

end.
