unit InfoFrm;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TShowInfoForm = class(TForm)
    ShowInfoLabel: TLabel;
  private
    { Private declarations }
    procedure SetMsg(const AMsg: string);
    function GetMsg: string;
  public
    { Public declarations }
    property Msg: string read GetMsg write SetMsg;
  end;

var
  ShowInfoForm: TShowInfoForm;

procedure InfoFormShow(AMsg:string);
procedure InfoFormHide;

implementation

procedure TShowInfoForm.SetMsg(const AMsg: string);
begin
  ShowInfoLabel.Caption := AMsg;
end;

function TShowInfoForm.GetMsg: string;
begin
  Result := ShowInfoLabel.Caption;
end;

procedure InfoFormShow(AMsg:string);
begin
  ShowInfoForm.ShowInfoLabel.Caption := AMsg;
  ShowInfoForm.Show;
  Application.ProcessMessages;
end;

procedure InfoFormHide;
begin
  ShowInfoForm.Hide;
end;

{$R *.DFM}

end.
