unit ModuUtl;{v0.24}
{ utility functions for hardware devices - modules }

interface
{v0.28}
uses
  Language;
{/v0.28}

{ see language }
{AutoSampler}
type
  TASState = integer;
  { AutoSampler state }
{assXXXX}
const

  astOK = 0;
  astPrepared = 1;
  astOperating = 2;

  astError = 3;

  astCalibrationError = 3;
  astSensorAError = 4;
  astSensorBError = 5;
  astSequencerError = 6;
  astArmMotorError = 7;
  astPeristalticMotorError = 8;
  astDCMotorError = 9;
  astDiskPositionError = 10;
  astBubbleError = 11;
  astUnidentifiedError = 12;
  astCommunicationError = 13;
  astUnknownState = 14;

  ASStateCount = 15;
{/assXXXX}


function AS_STATUS_ToString(AStatus: word): string;

function AS_STATUS_Decode(AStatus: word) : TASState;
  { converts AutoSampler STATUS property to TASState (astXXXX) value  }
{c:\mikro\analytik.pas}
{c:\mikro\jazyk_en.pas}
{c:\mikro\deklarac.pas}

function ASStateToString(ast: TASState): string;
{/AutoSampler}

{Devices (other than AutoSampler) }
function DevStatToInt(AStatus: integer): integer;
  { converts Device Status WORD value to Int16 value }

{dstXXXX}
{ Device / Module state }
type
  TDevState = integer;
const
  dstOK = 0;
  dstOutOfLimits = 1;
  dstTooHigh = 2;
  dstTooLow = 3;
  dstUnstable = 4;
  dstDefectiveLamp = 5;
  dstTooDark = 6;
  dstCommunicationError = 7;
  dstUnknownState = 8;
  dstOff = 9;
  dstDeviceError = 10;

  DevStateCount = 11;
{/dstXXXX}

function DevStateToString(dst: TDevState): string;
{/Devices}

implementation

{AutoSampler}
const
  AAStateMsgs : array[0..ASStateCount - 1] of string[35] =    { 40 }
	    (
{ Error  0     'Dvkova je v zkladn pozici  ',
{ Error  0}    {#}'Idle',
       { 1     'Vzorek pipraven ve smyce     ',
       { 1}    {#}'Sample prepared in the loop',
       { 2     'Dvkova pracuje               ',
       { 2}    {#}'Sampler operating',
       { 3     'Nelze nastavit citlivost idel ',
       { 3}    {#}'Sensor sensit. cannot be set',
       { 4     'Chyba idla A nebo nen vzorek ',
       { 4}    {#}'Sensor A error or no sample',
       { 5     'Chyba idla B nebo bublina     ',
       { 5}    {#}'Sensor B error or a bubble',
       { 6     'Chyba v sekvenceru dvkovn   ',
       { 6}    {#}'Error in sampler sequencer',
       { 7     'Chyba v motoru ramnka         ',
       { 7}    {#}'Arm motor error',
       { 8     'Chyba v motoru peristaltiky    ',
       { 8}    {#}'Peristaltic system motor error',
       { 9     'Chyba v nkterm DC motoru     ',
       { 9}    {#}'Error in some of the DC motors',
       {10     'Chyba polohovn kotoue       ',
       {10}    {#}'Disk position error',
       { ---------------------------------------}
       {11     'Bublina ve vzorku; mlo vzorku ',
       {11}    {#}'Bubble or not enought of sample',
      {>11     'Neidentifikovateln chyba      '
      {12}    {#}'Unidentified error',
      {13}    {#}'Communication error',
      {14}    {#}'Unknown state'
	    );


function AS_STATUS_ToString(AStatus: word): string;
begin
  Result := GetTxt(AAStateMsgs[AS_Status_Decode(AStatus)]);
end;

function AS_STATUS_Decode(AStatus: word) : TASState;
var ST : integer;
begin
   ST:= AStatus;{IPOD_ST;}
   if      ST=0   then Result:=0
   else if ST=$81 then Result:=1
   else if (ST > 0) and (ST < $8000) then Result:=2
   else if ST and $FF00 =$FD00 then
   begin	{ Sekvencer }
    if      ST and $FF=$88 then Result:=3
    else if ST and $FF=$89 then Result:=4
    else if ST and $FF=$8A then Result:=5
    else Result:=6
   end
   else if ST and $FF00 =$FE00 then
   begin	{ Multi reg }
    if      ST and $FF=$90 then Result:=7
    else if ST and $FF=$91 then Result:=8
    else Result:=9
   end
   else if ST and $FF00 =$FC00 then
   begin	{ Krokac }
     Result:=10
   end
   else Result:=12;
end;

function ASStateToString(ast: TASState): string;
begin
  if (ast < 0) or (ast >= ASStateCount) then
    ast := astUnidentifiedError;
  Result := GetTxt(AAStateMsgs[ast]);
end;

{/AutoSampler}


{Devices (other than AutoSampler) }
function DevStatToInt(AStatus: integer): integer;
begin
  if AStatus >= $8000 then
    dec(AStatus, $10000);
  Result := AStatus;
end;

type
  TStateString = string[40];

const
  FDevStateStrings: array [0..DevStateCount-1] of TStateString = (
   {#}'O.K.',
   {#}'Out of limits',
   {#}'Too high',
   {#}'Too low',
   {#}'Unstable',
   {#}'Defective lamp',
   {#}'Too dark',
   {#}'Communication error',
   {#}'Unknown state',
   {#}'Off',
   {#}'Device error'
  );

function DevStateToString(dst: TDevState): string;
begin
  if (dst < 0) or (dst >= DevStateCount) then
    dst := dstUnknownState;
  Result := GetTxt(FDevStateStrings[dst]);
end;
{/Devices}

end.
