unit SeqFrm;{v0.41}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Sequenceu, Beeper;

type

  TSeqForm = class(TForm)
    CancelButton: TButton;
    OKButton: TButton;
    MsgMemo: TMemo;
    SoundOnLoadCheckBox: TCheckBox;
    SampleEdit: TEdit;
    Label1: TLabel;
    SoundOnInjectCheckBox: TCheckBox;
    procedure OKButtonClick(Sender: TObject);
    procedure CancelButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    FSequence: TSSequence;
    FState: TSeqFormState;
    FBeeper: TBTBeeper;
    {FSampleName: string;}
    procedure SetState(AState: TSeqFormState);
    procedure SetSampleName(const AName: string);
    procedure CancelPressed;
    procedure OKPressed;
  public
    { Public declarations }
    procedure DoSound;
    property State: TSeqFormState read FState write SetState;
    property Sequence: TSSequence read FSequence write FSequence;
    property SampleName: string write SetSampleName;
  end;

var
  SeqForm: TSeqForm;

implementation

{$R *.DFM}

procedure TSeqForm.OKButtonClick(Sender: TObject);
begin
  OKPressed;
end;

procedure TSeqForm.CancelButtonClick(Sender: TObject);
begin
  CancelPressed;
end;

procedure TSeqForm.SetState(AState: TSeqFormState);
var okOn, abortOn: boolean;
begin
  if FState = AState then
    exit;
  okOn := true;
  abortOn := true;
  case AState of
    sfsLoadSample: begin
      MsgMemo.Text := 'LOAD sample' + #13#10 +
        'PRESS OK when ready OR wait for inject request';
      {SoundCheckBox.Checked := true;}
    end;

    sfsLoaded: begin
      MsgMemo.Text := 'Sample loaded';
      okOn := false;
    end;

    sfsInjected: begin
      MsgMemo.Text := 'Sample injected';
      okOn := false;
    end;

    sfsInjectSample: begin
      MsgMemo.Text := 'INJECT the sample' + #13#10 +
         'PRESS OK or MARK(on Pump/Detector)';
      {SoundCheckBox.Checked := true;}
    end;

    sfsLoadAndInjectSample: begin
      MsgMemo.Text := 'LOAD and INJECT the sample' + #13#10 +
        'PRESS OK or MARK(on Pump/Detector)';
      {SoundCheckBox.Checked := true;}
    end;

    sfsFinished: begin
      MsgMemo.Text := 'Analysis finished.';
      abortOn := false;
    end;

    sfsAborted: begin
      MsgMemo.Text := 'Analysis aborted.';
      abortOn := false;
    end;

  end;
  FState := AState;
  OKButton.Enabled := okOn;
  CancelButton.Visible := abortOn;
end;

procedure TSeqForm.CancelPressed;
begin
  if FSequence <> nil then
    FSequence.DoCancel;
end;

procedure TSeqForm.OKPressed;
begin
  if FSequence <> nil then
    FSequence.DoOK;
end;

procedure TSeqForm.FormCreate(Sender: TObject);
begin
  State := sfsLoadSample;
  FBeeper := TBTBeeper.Create(Self);
end;

procedure TSeqForm.SetSampleName(const AName: string);
begin
  if AName <> '' then
    SampleEdit.Text := AName;
end;

procedure TSeqForm.DoSound;
var
  doit: boolean;
begin
  doit := false;

  if SoundOnLoadCheckBox.Checked then begin
    case State of
      sfsLoadSample, sfsLoadAndInjectSample: doit := true;
    end;
  end;

  if SoundOnInjectCheckBox.Checked then begin
    case State of
      sfsInjectSample, sfsLoadAndInjectSample: doit := true;
    end;
  end;

  if doit then begin
    MessageBeep(1);
    FBeeper.PlayDefaultSound;
  end;
end;

end.
