unit HtmlHelp;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  hh, hh_funcs;

type
  THtmlHelp = class(TComponent)
  private
    { Private declarations }
    FHHS: THookHelpSystem;
    FCHMName: string;
      { Name of the .chm file to use. If not assigned, application
        name is used }
    FHostType: THostType;
  protected
    { Protected declarations }
    procedure SetCHMName(const AName:string);
    procedure SetHostType(AHostType: THostType);
    procedure HHSUpdate;
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); reintroduce;
    destructor Destroy;override;
  published
    { Published declarations }
    property CHMName: string read FCHMName write SetCHMName;
    property HostType: THostType read FHostType write SetHostType default htHHexe;
  end;

procedure Register;

implementation

constructor THtmlHelp.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FHostType := htHHExe;
  HHSUpdate;
end;

procedure THtmlHelp.HHSUpdate;
var
  fn:string;
begin
  if FHHS <> nil then begin
    FHHS.Free;
    FHHS := nil;
    {HHCloseAll;}
  end;
  if FCHMName = '' then
    fn := ChangeFileExt(Paramstr(0), '.CHM')
  else
    fn := FCHMName;
  FHHS := THookHelpSystem.Create(fn, '', HostType);
end;

procedure THtmlHelp.SetCHMName(const AName:string);
begin
  if FCHMName <> AName then begin
    FCHMName := AName;
    HHSUpdate;
  end;
end;

procedure THtmlHelp.SetHostType(AHostType: THostType);
begin
  if FHostType <> AHostType then begin
    FHostType := AHostType;
    HHSUpdate;
  end;
end;

destructor THtmlHelp.Destroy;
begin
  FHHS.Free;
{  HHCloseAll;}
  inherited Destroy;
end;

procedure Register;
begin
  RegisterComponents('NonVis', [THtmlHelp]);
end;

end.
