unit LogFrm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExeLogu;

type
  TLogForm = class(TForm)
    LogMemo: TMemo;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    {v0.26}
    FIsInLog: boolean;
    {/v0.26}
    { Private declarations }
  public
    { Public declarations }
    procedure Log(const msg: string);
  end;

{v0.24}
function LogForm: TLogForm;
{/v0.24
var
  LogForm: TLogForm;}

implementation

{$R *.DFM}

{v0.24}
const
  FLogForm: TLogForm = nil;

function LogForm: TLogForm;
begin
  if FLogForm = nil then
    FLogForm := TLogForm.Create(Application.MainForm);
  Result := FLogForm;
end;
{/v0.24}

procedure TLogForm.Log(const msg: string);
var i: integer;
begin
  {v0.26}
  if ComponentState <> [] then
    exit;
  if FIsInLog then
    exit;
  FIsInLog := true;
  try
  {/v0.26}
  if LogMemo.Lines.Count > 800 then begin
    for i := 1 to 400 do
      LogMemo.Lines.Delete(0);
  end;
  LogMemo.Lines.Add(msg);
  {v0.26}
  finally
    FIsInLog := false;
  end;
  {/v0.26}
end;

procedure TLogForm.FormCreate(Sender: TObject);
begin
  ExeLog.OnLog := Log;
end;

procedure TLogForm.FormDestroy(Sender: TObject);
begin
  ExeLog.OnLog := nil;
end;

end.
