unit ULObjUsrTmpu;{template for TULObjUsrTmp descendants}
{ replace:
  XUsrTmps - XXXsID
  XUsrTmp  - XXXrID
  UsrTmps  - XXXs User
  UsrTmp   - XXXr User
}
interface
uses
  SysUtils, Classes, Controls, ActnList, Menus, Dialogs, Forms,
  WinUtl, Msgu, ULRecTyp, ULObju, ULObjUsrTmpu, ULStringGrid;

type
  TUsrTmp = class(TULObjUsrTmp)
  private

  protected
    function GetRecID: TULRecID; override;
    function GetXUsrTmp: TXUsrTmpObj;

    procedure BeforeDelete; override;
    procedure FieldChangedInBrowser(AField: TULObjField); override;
  public
    constructor Create(AOwner: TULObjUsrTmp; AObj: TULObj; ARecID: TULRecID); reintroduce;
    property AUsrTmp: TXUsrTmpObj read GetXUsrTmp;
  end;

  TUsrTmps = class(TULObjUsrTmp)
  private
  protected
    function ChildCreate(AChildObj: TULObj): TULObjUsrTmp; override;
    function GetRecID: TULRecID; override;

    procedure FirstMenuActionNeeded; override;
    procedure DoAfterCreate;override;
    procedure ULGridFormActivated(AGrid: TULStringGrid); override;
    procedure ULGridFormDeactivated(AGrid: TULStringGrid); override;
    function GetUsrTmp(Index: integer): TUsrTmp;
    procedure AfterBrowseChildDelete; override;
    procedure AfterChildsDelete; override;
  public
    destructor Destroy; override;
    function UsrTmpFind(AUsrTmpID: TUsrTmpID; var AUsrTmp: TUsrTmp): boolean;
    function UsrTmpAdd: TUsrTmp;
    property UsrTmps[Index: integer]: TUsrTmp read GetUsrTmp; default;
  end;

function UsrTmps: TUsrTmps;

implementation
const
  FUsrTmps: TUsrTmps = nil;
  UsrTmpsFileName = 'UsrTmps.ULF';

function UsrTmps: TUsrTmps;
begin
  if FUsrTmps = nil then begin
    if FileExists(DataDir + UsrTmpsFileName) then begin
      FUsrTmps := TUsrTmps.Load(DataDir + UsrTmpsFileName);
    end else begin
      FUsrTmps := TUsrTmps.Load('');
      FUsrTmps.FileName := DataDir + UsrTmpsFileName;
    end;
    FUsrTmps.Obj.ObjDesc.GridOptions := [ogAutosizeBrowseCols, ogColumnSortEnabled];
    FUsrTmps.Obj.ObjDesc.ExcludedMenuItems :=
      [{omHeader, omFocused, omGridOptions, omCopy,} omSaveAs,
       omPaste, omDeleteSelected, omDeleteAll, {omSort,} {omChildAdd, }omChildInsert,
       {omChildDelete, }omChildFileSelect, omPrintOptions, omPrint];{ulobjact}

    {!!}FUsrTmps.Obj.ChildsSetFlag(rfOwnMessageOnSelect, true);
  end;
  Result := FUsrTmps;
end;

{TUsrTmp}
procedure TUsrTmp.BeforeDelete;
begin
end;

function TUsrTmp.GetXUsrTmp: TXUsrTmpObj;
begin
  Result := TXUsrTmpObj(Obj);
end;

constructor TUsrTmp.Create(AOwner: TULObjUsrTmp; AObj: TULObj; ARecID: TULRecID);
begin
  inherited;
end;

function TUsrTmp.GetRecID: TULRecID;
begin
  Result := XUsrTmpID;
end;

procedure TUsrTmp.FieldChangedInBrowser(AField: TULObjField);
begin
  if (AField.FldDesc.Name = 'UsrTmpName')
  begin

  end;
end;
{/TUsrTmp}


{TUsrTmps}
function TUsrTmps.GetRecID: TULRecID;
begin
  Result := XUsrTmpsID;
end;

function TUsrTmps.ChildCreate(AChildObj: TULObj): TULObjUsrTmp;
begin
  Result := TUsrTmp.Create(Self, AChildObj, AUsrTmpID);
end;

procedure TUsrTmps.FirstMenuActionNeeded;
begin
// ActionUpdate(FAssignTouchAction, AssignTouch, GetTxt({#}'Assign Medium'));
end;

function TUsrTmps.UsrTmpFind(AUsrTmpID: TUsrTmpID; var AUsrTmp: TUsrTmp): boolean;
var
  u: TUsrTmp;
  i: integer;
begin
  Result := false;
  for i := 0 to ChildCount - 1 do begin
    u := TUsrTmp(Childs[i]);
    if u.UsrTmpID = AUsrTmpID then begin
      Result := true;
      AUsrTmp := u;
    end;
  end;
end;

function TUsrTmps.UsrTmpAdd: TUsrTmp;
begin
  Result := TUsrTmp(ChildAdd(nil, XUsrTmpID, ''));
end;

procedure TUsrTmps.ULGridFormActivated(AGrid: TULStringGrid);
begin
  inherited;
end;

procedure TUsrTmps.ULGridFormDeactivated(AGrid: TULStringGrid);
begin
  inherited;
end;

procedure TUsrTmps.DoAfterCreate;
begin
end;

function TUsrTmps.GetUsrTmp(Index: integer): TUsrTmp;
begin
  Result := TUsrTmp(Childs[Index]);
end;

procedure TUsrTmps.AfterBrowseChildDelete;
begin
end;

procedure TUsrTmps.AfterChildsDelete;
begin
end;

destructor TUsrTmps.Destroy;
begin
  if FUsrTmps = Self then
    FUsrTmps := nil;
  inherited;
end;
{/TUsrTmps}

initialization

finalization
  FUsrTmps.Free;
end.
