unit AAPLType;
  { Aminoacid Analyzer program line; source for MakeComp program }
interface
uses
  UlanType, ULRecTyp;
const
  AAPLID = ord('A') + 256* ord('A') + 256 * 256 * ord('P')+ 256 * 256 * 256 * ord('L');

type
  {v0.38}
  TAAPrgLineState = (plsNone, plsWaiting, plsRunning, plsDone, plsFailed, plsSkipped);
    { plsNone - the whole program is not active
      plsWaiting - the program is running (or is ready to run), but the time of
                  the line did not come yet
      plsRunning - the commands of the command line are just beeing executed
                  (in this state should be only for very short time, the
                  user of the line information should set the state to plsDone
                  as soon as the info is not needed anymore)
      plsDone    - the line commands were successfully executed
      plsFailed  - the line commands were tried to execute but failed
      plsSkipped - the line commands were skipped (time passed but the commands
                   were not executed, set to this value if user did not changed
                   the state from plsRunning to plsDone or plsFailed) }
  {/v0.38}

  TAABufferNr = (bnNoChange, bn1, bn2, bn3, bn4, bn5, bn6);
  TAACommand = (
    acNone,   { no command }
    acInject, { inject sample loaded to injector by acLoad command onto the column }
    acZero,   { zero detector }
    acH2O,    { switch pump2 valve to H2O }
    acNHD,    { switch pump2 valve to NHD }
    acAcqStop, { stop data acquisition (stop storing data to file) }
    acStartEquil, { start equlibration of the column (get ready for analysis),
      all following program steps are considered top be part of the preparation
      of column for injecting next sample);
      this part of the program will be run first also if the sample is
      the first one in the sequence or the previous program was different }
    acLoad    { load sample to injector (get ready for inject) }
  );
  {aapgtype ulprtype}

  TAAPLRec = packed record {<Caption="AA Prg.Line" Enabled=1 Visible=1
    SortExp=PrgTime SortedByNumber=1 EditModal=1>}
    Head: TULRecHead;
    Info: TULRecInfo;
    PrgTime: TAcqTime;{<Enabled=1 UserCoef=60 NumDec=2 Caption="Time [min]"
      IsSortField=1>}
      { At what time from program start (in seconds internally, to user
        shown in minutes) the program line should execute }
    Temperature: TTemperature;{<Enabled=1 NumDec=2 Caption="Column T[C]">}
    BufferNr: TAABufferNr;{<Enabled=1 Caption="Buffer Nr." Type=Enum
      StripPrefix=bn>}
    Command: TAACommand;{<Enabled=1 Caption="AA Command" Type=Enum StripPrefix=ac>}
    Note: string;{<Enabled=1 Caption="Note">}
    {v0.38}
    State: TAAPrgLineState;{<Hint="State of the program line"
      Colors=clWhite,clWhite,clWhite,clGreen,clBlack,clYellow,clBlack,clGray,clWhite,clRed,clBlack,clWhite
      StripPrefix=pls>}
    {/v0.38}
  end;
  PAAPLRec = ^TAAPLRec;

implementation

end.
