unit ULAType;
  { Format of ULA = analysis  record (head of ULA datafiles),
    source for MakeComp program }
interface
uses
  UlanType, ULRecTyp;
const
  ULAExt = '.ULA';
  ULAID = ord('U') + 256* ord('L') + 256 * 256 * ord('A');


type
  TULARec = packed record {<Caption="Sample" RootChild=1
     ChildRecIDs=ULADID,ULAFID,ULIID,ULMID,AAPGID HasRecName=1
     Uses=ULADType,ULAFType,ULIType,ULMType,AAPGType
     OpenFilter="uLan file (*.ULF)|*.ULF|Raw data (*.DAT)|*.DAT|All files (*.*)|*.*|Raw ASCII data  (*.TXT)|*.TXT|uLan ASCII file (*.ASC)|*.ASC|Micro AAA (*.G;*.B)|*.G;*.B|Template (*.ULT)|*.ULT"
     SaveFilter="uLan Analysis File (*.ULF)|*.ULF|Raw Data (*.DAT)|*.DAT|Raw ASCII (*.TXT)|*.TXT|uLan Analysis ASCII (*.ASC)|*.ASC|uLan Analysis Template (*.ULT)|*.ULT"
     AskForSave=1 Enabled=1 Visible=1>}
    { Raw data holded in TULSDObj object, filtered
      data holded in TULSFObj object }
    Head: TULRecHead;
    Info: TULRecInfo;
    SampleName:TSampleName;{<Enabled=1>}
      { Name of the sample. }
    SampleDesc:TSampleDesc;{<Enabled=1 Caption="Sample Desc.">}
      { Longer description of the sample. }
    Amount: TSampleAmount;{<Enabled=1 Hint="Note about what amount of the sample used">}
      { Amount of the sample used (in user chosen units) }
    ISTDAmount: TSampleAmount;{<Enabled=1 Hint="What is the amount of ISTD (used if not specified at ISTD peak)">}
    InjectionVolume: TInjectionVolume;{<Enabled=1 Caption="Inj.volume[ul]">}
    CalibrationStandard: boolean;{<Enabled=1>}
      { Is this analysis beeing used as calibration standard? }
    ExternalStartEnabled: boolean;{<Enabled=1>}
    UserID:TUserID;{<Enabled=1>}
      { User id of the analyst. }
    UserName:TUserName;{<Enabled=1>}
      { Short name of the analyst (copy from ulu file, for the case the UserID
        record will be deleted from ulu file). }
    MultiplyFactor: TFactor;{<Enabled=1 DefVal=1 Hint="Used to multiply peak results with">}
      { Same meaning as Factor is method, but can be different for each sample,
        during calculations results are multiplied by both - sample and method
        factors. Introduced in Chromulan v0.25.}
    DateTime: longint;{<Caption="Date,Time" Hint="Date/Time when was the acquisition finished"
      Type=FileDateTime Enabled=1>}
      { Introduced in version 0.28 }
    DivideFactor: TFactor;{<Enabled=1 DefVal=1 Hint="Used to divide peak results with">}
    AutodetectLater: boolean;{<Enabled=1 NonVisible=1>}
      { Set true if autodetect should be made upon next data open
        (used e.g. if data acquired in sequences so that failure of autodetect
        won't stop the sequence) }
  end;
  PULARec = ^TULARec;

implementation

end.
