unit ULEType;
  { Ulan raw data export/import definition record;
    information about the other format file structure }
interface
uses UlanType, ULRecTyp;{ULREC.LST}

const
  UleID = ord('U') + 256*ord('L') + 256*256*ord('E');

type
  TULERec = packed record {<RootChild=1 Caption="Exp./Imp.Def."
    Enabled=1 Visible=1 HasRecName=1>}
    Head: TULRecHead;
    Info: TULRecInfo;
    DefName: TImpExpDefName;{<Enabled=1>}
      { Unique name for the definition. }
    TextFile: boolean;{<Enabled=1>}
      { Is the imported file textfile? (false -> binary file). }
    XValueType: TXValueType;{<Type=Enum Enabled=1 StripPrefix=xt>}
      { Does the file contain X values?
        (if yes, what is the format - for binary files). }
    XInterval: TXValue;{<Enabled=1>}
      { If the file does not contain X values, what is the
        time difference between Y values (in seconds) }
    YValueType: TYValueType;{<Type=Enum Enabled=1 StripPrefix=yt>}
      { for binary files specifies size and format
        of bytes holding the Y value }
    XCoef: single;{<Enabled=1>}
      { Use this coeficient to multiply other X value to get the default
        X value (i.e. in seconds); if = 0 no multiplying done. }
    YCoef: single;{<Enabled=1>}
      { Use this coeficition to multiply other Y value to get the default
        Y value (i.e. in absorbation units) }
    HeadLen: longint;{<Enabled=1>}
      { If binary file, than this is offset, where the raw data start. }
    ValueDelimiter: TDelimiterString;{<Enabled=1>}
      { What is character between x and y value on the line (for TextFiles),
        usually space, comma, semicolon or tab; used just for exporting
        to text file, for import all those are tested. If non readable
        char should be used, use hexa in format e.g. $09 (for tab) }
    LineDelimiter: TDelimiterString;{<Enabled=1>}
      { What are the characters delimiting lines, usually CRLF. }
    {v0.18}
    ExtName: TExtName;{<Enabled=1>}
      { Default file extension for this data format (including '.') }
    {/v0.18}
  end;
  PULERec = ^TULERec;


implementation

end.
