unit ULIType;
{ description of .ULI  instrument file records formats }
interface
uses
  UlanType, ULRecTyp;{ULREC.LST}

const
  ULIExt = '.ULI';
    { Instrument file extension }
  ULIID = ord('U') + 256*ord('L') + 256*256*ord('I');
    { ID of instrument record }

type

  TULIRec = packed record {<Caption="Instrument" ChildRecIDs=ULGID
    RootChild=1 Uses=ULGType,ULLType Enabled=1 Visible=1
    Create1="DataWaitTimeout := DefDataWaitTimeout;">}
    Head: TULRecHead;
      { Head.RecID set to UliID, Head.RecLen = sizeof(TUliRec) }
    Info: TULRecInfo;
    InstrumentTemplate: TULFileName;{<Enabled=1 ReadOnly=1 Type=FileName>}
      { what file was used as the template for creation of this file
        ( = '' if none) }
    Column: TColumnName;{<Enabled=1>}
      { description of the column used for separation }
    MobilePhase: TMobilePhase;{<Enabled=1>}
      { description of the mobile phase used for separation }
    FlowRate: TFlowRate;{<Enabled=1>}
      { what flow rate was used for the separation (if no gradient used),
        or starting flow rate (if gradient used) }
    FlowRateUnit: TFlowRateUnit;{<Type=Enum Enabled=1 StripPrefix=fu>}
      { What units are used for FlowRate values. }
    Detection: TDetection;{<Enabled=1>}
      { description of detection method used }
    Temperature: TTemperature;{<Enabled=1>}
      { what was the temperature during the measurement }
    TemperatureUnit: TTemperatureUnit;{<Type=Enum Enabled=1 StripPrefix=tu>}
      { what unit is used for Temperature values }
    InstrumentFileName: TULFileName;{<Enabled=1 Type=FileName ReadOnly=1>}
      { to what file was the instrument object info saved
        (if any, makes sense if was modified) }
    {v0.14}
    ChannelName: TChannelName;{<Enabled=1 Type=ULEnum ValuesSourceRecID=ULLID>}
    {/v0.14}
    {v0.15}
    Duration: single;{<Enabled=1 UserCoef=60 NumDec=2
      Caption="Duration of Analysis [min]">}
      { If non zero, then after this time the acquisition
        will autostop }
    SamplingInterval: single;{<Enabled=1 Caption="Sampling interval [s]">}
      { If non  zero, then defines other then default interval for taking
        epxerimental values from the device }
    {/v0.15}
    {v0.21}
    DataWaitTimeout: single;{<Enabled=1 Caption="How long wait for data [s]">}
      { If no data are comming from the port for longer time than specified
        here, acquisition will be suspended and error reported. Default
        value = 5 s (used also if 0 specified). }
    {/v0.21}
  end;
  PULIRec = ^TULIRec;

implementation

end.
