unit ULSQType;
  { Ulan Sequence, source for MakeComp program }
interface
uses
  UlanType, ULRecTyp;
const
  ULQExt = '.ULQ';{template}
  ULSExt = '.ULS';
  ULSQID = ord('U') + 256* ord('L') + 256 * 256 * ord('S') + 256 * 256 * 256 * ord('Q');

type
  TSequenceName = string[40];
  TSequenceDesc = string;
  TSequenceStatus = (ssWaiting, ssRunning, ssIdle, ssBreak);
  TActionOnSignal = (asStop, asRunAgain, asIgnore);
  {v0.30}
  TResultTableValue = (tvAmount, tvArea, tvRatio, tvResponse, tvX, tvWidth, tvHeight);
const {ulprtype}
  ResultTableValueName : array[TResultTableValue] of string
    = ('Amount', 'AreaSize', 'Ratio', 'Response', 'X', 'Width', 'Height');
  {/v0.30}

type
  TULSQRec = packed record {<Caption="Sequence" RootChild=1
     OpenFilter="Sequence (*.ULS)|*.ULS" SaveFilter="Sequence (*.ULS)|*.ULS"
     ChildRecIDs=ULSRID,ULIID,ULMID HasRecName=1 BrowseChildRecIDs=ULSRID
     BrowseFieldList=SequenceName,SequenceDesc,Status,VialNr,FileMask
     Uses=ULSRType,ULIType,ULMType Enabled=1 Visible=1 EditModal=1>}
    Head: TULRecHead;
    Info: TULRecInfo;
    SequenceName:TSequenceName;{<Caption="Sequence name" ReadOnly=1
      Hint="Sequence name is a name of the subdirectory where samples data will be stored">}
      { Name of the sequence (= subdirectory). This subdirectory will be created
        in the dir where is this .ULS file (for AAA specified by AAAObj.SeqsDir).
        The name is created automatically from current date (yymmdd), order number
        in the current date is added (yymmdd-n).
        Base name of the .ULS file also equals to Sequence name, bat has in addition
        .ULS extension. }
    SequenceDesc:TSequenceDesc;{<Enabled=1 Caption="Sequence Desc.">}
      { Description of the sequence (what are the samples from, etc.). }
    Active: boolean;
      { If true then controlled by software otherwise by sampler }
    ActionOnSignal: TActionOnSignal;
      { what to do upon signal from device }
    Duration: single;
      { default duration of one analysis (see ulitype) in seconds }
    IdleTime: single;
      { interval between samples (end of first - start of second) in seconds }
    Status: TSequenceStatus;
      { in what run status is the sequence }
    VialNr: integer;
      { What is the current sample (vial in autosamlper), 0 if none }
    FileMask: string;
      { How should look file names for acquired data of each run.
        E.g. "Sample*" will generate names Sample1, Sample2, ... . }
    PrgFileName: string;{<Enabled=1 Caption="Program" Type=FileName
      Filter="AA Analyser Program (*.AAP)|*.AAP">}
      { Default program file name for new sequence sample. }
    MethodFileName: string;{<Enabled=1 Caption="Method" Type=FileName
      Filter="Method (*.ULM)|*.ULM">}
      { Default method file name for new sequence sample. }
    ResultTableValue: TResultTableValue;{<Enabled=1 Caption="Results Value"
      Type=Enum Hint="Value of what peak property will be shown in results table"
      StripPrefix=tv>}
    DataTemplateFileName: string;{<Enabled=1 Caption="Template" Type=FileName
      Filter="Template (*.ULF)|*.ULT">}
      { v0.41 template used for creation data files and for accessing instrument,
        channel settings. Default set to UlanDefaultSeq.ULT.
        Used in standalone (non AAA) sequences. }
  end;
  PULSQRec = ^TULSQRec;

implementation

end.
