unit rttype;
{$I define.pas}
interface
type
  TRTResult = integer;

  TRTTaskProcedure = procedure;
  PRTDuration = ^TRTDuration;
  TRTDuration = longint;

  TRTSemaphoreKind = (Counting, Binary, Resource);
  TRTName = string[15];
  TRTSemaphore = record
    Queue:pointer;
    Count:word;
    SemID:word;
    Name:TRTName;
    Kind:TRTSemaphoreKind;
    Fill:byte;
    Next:pointer;
    Owner:pointer;
  end;

  PRTSemaphore = ^TRTSemaphore;
  PRTTaskHandle = ^TRTTaskHandle;
  TRTTaskHandle = pointer;

  PRTTaskPriority = ^TRTTaskPriority;
  TRTTaskPriority = byte;

  PRTTaskState = ^TRTTaskState;
  TRTTaskState = (Ready, Current, Suspended, Delaying,
    BlockedWait, TimedWait, BlockedPut, BlockedGet, TimedPut,
    TimedGet, BlockedSend, BlockedReceive, TimedSend,
    TimedReceive, Deadlocked, Illegal, Terminated);
  TRTStackRange = integer;

  TRTProperty = integer;
  TRTTaskProperty = integer;

  TIRQRange = 0..15;
  {(irq0, irq1, irq2, irq3, irq4, irq5, irq6,
    ir..15);}
  TIRQHandler = pointer;
const
  NoTask = nil;{!! dont know}
  NoTaskHandle = nil;
{MailBoxes}
type

  TRTMCBType = record
    WriteQueue:pointer;
    ReadQueue:pointer;
    Head,
    Tail,
    Count,
    Size,
    MCBId:word;
    Name:string[13];{in RTKernel its string[15], here used to store size of message}
    SlotSize:word;
  end;

const
  NoMailBox = nil;
  MailBoxSizeLimit = ($FFF0 - SizeOf(TRTMCBType));
{
  MailboxSizeLimit = ($FFF0 - SizeOf(RTMCBType)) DIV SizeOf(MessageType);
}
type
  TMBSlotSize = word;
  TMBSlotRange = 1..MailBoxSizeLimit;
{ MBSlotRange    = 1 .. MailboxSizeLimit;}
  MailBoxRec     = RECORD
    MCB : TRTMCBType;
    DataArray : ARRAY [TMBSlotRange] OF Byte;{MessageType}
  END;
{  MailBox        = ^MailboxRec;}

  PRTMailBox = ^TRTMailBox;
  TRTMailBox = ^MailBoxRec;

{/MailBoxes}

const
  RTMinPriority = 1;{!! dont know!!}
  RTMaxPriority = 64;

  FixTimeTaskPriority = 50;{from Timer unit}
{Semaphore kinds:}
  skResource = 2;

const
{rpXXXX RT properties}
  rpKeySemaphore = 1;{returns pointer to KeyAvail semaphore from rtkeybr unit}
  rpCurrentTaskHandle = 2;{returns pointer to current task handle }
{/rpXXXX}

{RTTextIO}
   CONST
      MaxCol = 131;
      MaxRow =  74;

      { Colour attributes for monochrom displays }
      Normal = $07; Reverse     = $70;
      Bright = $08; UnderLine   = $01;
      Blink  = $80;

      { Colour attributes for colour displays      Background colours      }
      Black  = $00; DarkGray    = Black  + Bright; BGBlack  = Black   SHL 4;
      Blue   = $01; LightBlue   = Blue   + Bright; BGBlue   = Blue    SHL 4;
      Green  = $02; LightGreen  = Green  + Bright; BGGreen  = Green   SHL 4;
      Cyan   = $03; LightCyan   = Cyan   + Bright; BGCyan   = Cyan    SHL 4;
      Red    = $04; LightRed    = Red    + Bright; BGRed    = Red     SHL 4;
      Magenta= $05; LightMagenta= Magenta+ Bright; BGMagenta= Magenta SHL 4;
      Brown  = $06; Yellow      = Brown  + Bright; BGBrown  = Brown   SHL 4;
      Gray   = $07; White       = Gray   + Bright; BGGray   = Gray    SHL 4;
                                                   BGYellow = BGBrown;
                                                   BGWhite  = BGGray;

      DefaultAttribute = Normal;
      FormFeed       = #12;     { written to a window acts like ClrScr }

   TYPE
      ColRange       = 0 .. MaxCol;
      RowRange       = 0 .. MaxRow;
      Colour         = Byte;    { see constants above }
      TitleString    = STRING[MaxCol-3];
      FKeyString     = STRING[15];

type
  TFileRec = record
    Handle: Word;
    Mode: Word;
    RecSize: Word;
    Private: array[1..26] of Byte;
    UserData: array[1..16] of Byte;
    Name: array[0..79] of Char;
  end;

  PTextBuf = ^TTextBuf;
  TTextBuf = array[0..127] of Char;
  TTextRec = record
    Handle: Word;
    Mode: Word;
    BufSize: Word;
    Private: Word;
    BufPos: Word;
    BufEnd: Word;
    BufPtr: PTextBuf;
    OpenFunc: Pointer;
    InOutFunc: Pointer;
    FlushFunc: Pointer;
    CloseFunc: Pointer;
    UserData: array[1..16] of Byte;
    Name: array[0..79] of Char;
    Buffer: TTextBuf;
  end;
{/RTTextIO}

{tpXXXX Task Properties}
const
  tp0 = 5000;
  tpSuspended = tp0 + 1; {boolean}
  tpState = tp0 + 2;     {TRTTaskState}
  tpPriority = tp0 + 3;  {TRTTaskPriority}

{/tpXXXX}
{rrXXXX RTResults}
const
  rrOK = 0;

  rr0 = 900;
  rrInvalidSetTaskProp = rr0 + 1;
  rrInvalidGetTaskProp = rr0 + 2;
  rrInvalidTaskHandle = rr0 + 3;
{/rrXXXX}
type
  PRTCreateTaskRec = ^TRTCreateTaskRec;
  TRTCreateTaskRec = record
    TaskCode:TRTTaskProcedure;
    Priority:TRTTaskPriority;
    Stack:TRTStackRange;
    Name:TRTName;
    Handle:TRTTaskHandle;
  end;

implementation
end.