{********************************************}
{*                                          *}
{*  SAXCOMM.PAS generated from SAXCOMM.VBX  *}
{*                                          *}
{********************************************}

unit Saxcomm;
interface

uses SysUtils, Classes, Graphics, Forms, Controls, VBXCtrl, BIVBX;

{ $DEFINE InitTComm}
{^- Remove space to enable default init data -- See documentation. }
const
  MaxGetBufferSize = 4 * 1024;


type
  string1 = string[1];
  { TComm }

  TComm = class(TVBXControl)
  protected
    { Event handler }
    procedure HandleVBXEvent(var Message: TWMVBXFireEvent); override;
  public
    constructor Create(AOwner: TComponent); override;

    property Index: TVBInteger index 1 read GetIntProp;
    property Receive: TVBString index 26 read GetStringProp write
      SetStringProp;
    property Send: TVBString index 27 read GetStringProp write SetStringProp;
    property Upload: TVBString index 31 read GetStringProp write
      SetStringProp;
    property Download: TVBString index 32 read GetStringProp write
      SetStringProp;
    property BytesTransferred: TVBLongint index 33 read GetLongProp write
      SetProp;
    property Display: TVBString index 37 read GetStringProp write
      SetStringProp;
    property DisplayLine: TVBString index 38 read GetStringProp write
      SetStringProp;
  published
    property BackColor: TColor index 2 read GetColorProp write SetColorProp
      default -2147483633;
    property ForeColor: TColor index 3 read GetColorProp write SetColorProp
      default -2147483640;
    property Visible;
    property DragMode;
    property DragCursor;
    property Caption;
    property BorderStyle: TVBEnum index 14 read GetEnumProp write SetEnumProp
      default 0;
    property TabOrder;
    property TabStop;
    property Enabled;
    property MousePointer: TVBEnum index 18 read GetEnumProp write
      SetEnumProp default 0;
    property Port: TVBString index 20 read GetStringProp write SetStringProp;
    property Speed: TVBLongint index 21 read GetLongProp write SetProp;
    property Parity: TVBEnum index 22 read GetEnumProp write SetEnumProp;
    property DataBits: TVBInteger index 23 read GetIntProp write SetIntProp;
    property StopBits: TVBInteger index 24 read GetIntProp write SetIntProp;
    property MaxReceiveLen: TVBInteger index 25 read GetIntProp write
      SetIntProp;
    property Echo: Boolean index 28 read GetBoolProp write SetBoolProp;
    property AutoReceive: Boolean index 29 read GetBoolProp write SetBoolProp;
    property AutoSend: Boolean index 30 read GetBoolProp write SetBoolProp;
    property XonXoff: Boolean index 34 read GetBoolProp write SetBoolProp;
    property CtsRts: Boolean index 35 read GetBoolProp write SetBoolProp;
    property About: TVBString index 36 read GetStringProp write SetStringProp
      stored False;
    property OnClick;
    property OnDragDrop;
    property OnEndDrag;
    property OnDragOver;
    property OnEnter;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property OnExit;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
  public
    function Get:Integer;
    procedure Put(Ch : byte);
  private
    Buffer : array [0..pred(MaxGetBufferSize)] of byte;
    Head, Tail: word;
  end;

procedure Register;

implementation

{ Default form data for TComm }

{$IFDEF InitTComm}

const
  TCommInitLen = 83;


procedure TCommInitData; near; assembler;
asm
	DB	$00,$04,$43,$6F,$6D,$6D,$01,$00,$00,$02,$00,$00,$7F,$00,$03,$FF
	DB	$FF,$FF,$00,$04,$08,$FF,$FF,$0A,$00,$0C,$00,$0D,$07,$73,$61,$78
	DB	$43,$6F,$6D,$6D,$0E,$00,$0F,$00,$00,$10,$00,$00,$11,$FF,$FF,$12
	DB	$00,$14,$00,$15,$60,$09,$00,$00,$16,$00,$17,$08,$00,$18,$01,$00
	DB	$19,$00,$00,$1C,$00,$00,$1D,$FF,$FF,$1E,$FF,$FF,$22,$00,$00,$23
	DB	$00,$00,$FF
end;

{$ENDIF}

{ TComm }

constructor TComm.Create(AOwner: TComponent);
begin
  FVBXFile := StrNew('SAXCOMM.VBX');
  FVBXClass := StrNew('saxComm');
  SetBounds(0, 0, 80, 32);
  inherited Create(AOwner);
  ControlStyle := ControlStyle - [csCaptureMouse, csClickEvents];
  TabStop := True;
  FVBXFlags := [vfArrows, vfLoadMessage];
  {$IFDEF InitTComm}
  FHForm := VBXCreateFormFile(TCommInitLen, @TCommInitData);
  {$ENDIF}
  Head := 0;
  Tail := 0;
end;

procedure TComm.HandleVBXEvent(var Message: TWMVBXFireEvent);
begin
  case Message.VBXEvent^.EventIndex of
    0: DispatchNotifyEvent(OnClick);
    1: begin end; { VCL Handles OnDragDrop }
    2: begin end; { VCL Handles OnDragOver }
    3: begin end; { VCL Handles OnGotFocus }
    4: DispatchKeyEvent(OnKeyDown, Message);
    5: DispatchKeyPressedEvent(OnKeyPress, Message);
    6: DispatchKeyEvent(OnKeyUp, Message);
    7: begin end; { VCL Handles OnLostFocus }
    8: DispatchMouseEvent(OnMouseDown, Message);
    9: DispatchMouseMoveEvent(OnMouseMove, Message);
    10: DispatchMouseEvent(OnMouseUp, Message);
  end;
end;

function TComm.Get:Integer;
var s:string;
  tomove : word;
  part:word;
{$IFDEF DEBUG}
  h, l, sh:longint;
{$ENDIF}
begin
  s := Receive;
{$IFDEF DEBUG}
  h := high(TVBLongint);
  sh := high(TVBString);
  l := BytesTransferred;
{$ENDIF}

  tomove := length(s);
  if tomove <> 0 then begin
    if tomove + Head <= MaxGetBufferSize then
      move(s[1], Buffer[Head], tomove)
    else begin
      part := MaxGetBufferSize - Head;
      move(s[1], Buffer[Head], part);
      Head := 0;
      tomove := tomove - part;
      move(s[succ(part)], Buffer[Head], tomove);
    end;
    inc(Head, tomove);
    if Head >= MaxGetBufferSize then
      Head := 0;
  end;
  if Tail <> Head then begin
    Get := Buffer[Tail];
    inc(Tail);
    if Tail >= MaxGetBufferSize then
      Tail := 0;
  end else
    Get := -1;
end;

procedure TComm.Put(Ch : byte);
begin
  Send := chr(ch);
end;

{ Designer registration }
procedure Register;
begin
  RegisterComponents('VBX', [
    TComm]);
end;

end.
