unit ifpsdelphi;

interface
uses
  ifpscall, ifspas, ifs_utl, ifs_var;

function RegisterDelphiFunction(ScriptEngine: TIfPasScript; const Declaration: String; Address: Pointer): Boolean;

{
Valid types for in Declaration:
Byte
Shortint
Word
Smallint
Cardinal
Longint
Integer
PChar (string with EXT param of TypeRec to 1) (*)
String

Valid calling conventions:
register (default)
stdcall
cdecl
pascal

* Does not support Var parameter.

}


implementation

function DProc(Sender: TIFPasScript; ScriptID: Pointer; Proc: PProcedure; Params: PVariableManager; res: PIfVariant): TIfPasScriptError;
begin
  if not InnerfuseCall(Nil, PProcedure(Proc)^._Ext, TCallingConvention(PProcedure(Proc)^._Ext2), Params, Res) then
  begin
    Sender.RunError2(Sender, ECustomError, 'Could not call function');
    DProc := ECustomError;
  end else
    DPRoc := ENoError;
end;

function RegisterDelphiFunction(ScriptEngine: TIfPasScript; const Declaration: String; Address: Pointer): Boolean;
var
  FuncName, FuncParam: string;
  cc: TCallingConvention;
  P: PProcedure;
begin
  if not ReadHeader(ScriptEngine, Declaration, FuncName, FuncParam, CC) then
    RegisterDelphiFunction := False
  else begin
    p := ScriptEngine.AddFunction(@dproc, 'procedure '+FuncName+';', Address);
    if assigned(p) then
    begin
      with P^ do
      begin
        _Ext2 := Pointer(CC);
        Decl := FuncParam;
        Name := FuncName;
      end;
      RegisterDelphiFunction := True;
    end else
      RegisterDelphiFunction := False;
  end;
end;

end.
