unit MikroToAAAu;
{ import of AAA program from Mikro }
interface
uses
  SysUtils, Classes, Fileu,
  UlanType, ULRecUtl, ULObju, ULObjUsru,

  AAPLType, AAPLObju,
  AAPGType, AAPGObju, AAPrgu;

procedure MicroToAAAPrg(const ASrcFileName: string; const ADestDir: string);

procedure MicroToAAA(const AMicroDir: string; const AAAADir: string);
  { converts all prg files in amicrodir to aap files to AAAADir }

implementation
type
  TMikroProgArrType = packed record
    Time  : real48;  { Cas provedeni ( -1 => ITabName ) }
    Colu  : real48;  { TeplotaKolony, 0 => beze zmeny   }
    Buff  : byte;    { Cislo pufru, 0 => beze zmeny     }
    Opti  : byte;    { 0 - nic, 1 - next, 2 - inject    }
                     { 3 - dataoff, 4 - start }
                     { 10 - zerro, 11 - A, 12 - B }
    Pars  : string[8];  { Znakovy parametr, je-li treba    }
  end;

procedure MicroToAAAPrg(const ASrcFileName: string; const ADestDir: string);
var
  ss: TFileStream;
  sr: TMikroProgArrType;
  pg: TAAPrg;
  pr: TAAPrgLine;
  dn: string;
  ac: TAACommand;

begin
  pg := TAAPrg.Load('');
  try
    if ADestDir <> '' then begin
      dn := AddBackSlash(ADestDir) + ExtractFileName(ChangeFileExt(ASrcFileName,
        ULRecDefFileExt(AAPGID)));
    end else begin
      dn := ChangeFileExt(ASrcFileName, ULRecDefFileExt(AAPGID));
    end;

    ss := TFileStream.Create(ASrcFileName, fmOpenRead);
    try
      while ss.Read(sr, sizeof(sr)) = sizeof(sr) do begin
        pr := TAAPrgLine(pg.ChildAdd(nil, AAPLID, ''));
        pr.AAPL.PrgTime := sr.Time * 60;
        pr.AAPL.Temperature := sr.Colu;
        pr.AAPL.BufferNr := TAABufferNr(sr.Buff);
        case sr.Opti of
          0: ac := acNone;
          1: ac := acLoad;{ - next, }
          2: ac := acInject;{ - inject    }
          3: ac := acAcqStop;{ - dataoff, }
          4: ac := acStartEquil;{ - start }
          10: ac := acZero; { 10 - zerro, }
          11: ac := acH2O;   {11 - A, 12 - B }
          12: ac := acNHD;
        end;
        pr.AAPL.Command := ac;
        pr.AAPL.Note := sr.Pars;
      end;
    finally
      ss.free;
    end;
    pg.SaveToFile(dn);
  finally
    pg.Free;
  end;
end;

procedure MicroToAAA(const AMicroDir: string; const AAAADir: string);
  { converts all prg files in amicrodir to aap files to AAAADir }
var
  f: TSearchRec;
  sd, dd: string;
begin
  sd := AddBackSlash(AMicroDir);
  dd := AddBackSlash(AAAADir);{filename}
  if findfirst(sd + '*.PRG', faAnyFile, f) = 0 then
  begin
    try
      repeat
        MicroToAAAPrg(sd + f.Name, AAAADir);
      until findnext(f) <> 0;
    finally
      findclose(f);
    end;
  end;
end;

end.
