unit Stopwch1;

{ Really quick and dirty high-res stopwatch using QueryPerformanceCounter.
  Needs to be spruced up with proper 64-bit arithmetic.
  Currently only good for one half-hour intervals

  03-31-98 GW Revisited and cleaned up a little
  05-06-96 GW Original

}

interface
uses windows;

Type
  TStopwatch = class
  public
    PerfCounterFreq: TLargeInteger; // Counts per second
    msDivider: DWORD;             // what to divide timestamps by to get ms
    
    StartTimeStamp: TLargeInteger;
    NewTimeStamp: TLargeInteger;
    
    LastElapsedTimems: integer;
    
    procedure Reset;
    constructor Create;
   { function ElapsedTimeSec: Real; }
    function ElapsedTimems: integer;
  end;

implementation

{--------------------------------}
constructor TStopwatch.Create;
{--------------------------------}
Var
  Success: boolean;
Begin
  Success := QueryPerformanceFrequency(Int64(PerfCounterFreq));
  msDivider := _LARGE_INTEGER(PerfCounterFreq).LowPart div 1000;
  Reset;
end;

{--------------------------------}
procedure TStopwatch.Reset;
{--------------------------------}
Var
  Success: boolean;
Begin
  Success := QueryPerformanceCounter(Int64(StartTimeStamp));
end;

{--------------------------------}
function TStopwatch.ElapsedTimems: integer;
{--------------------------------}
Var
  Success: boolean;
  NewLowPartSh, StartLowPartSh, ElapsedCountSh: integer;
  { shr avoids math problem with integer sign (ie: shr does not preserve sign) }
Begin
  Success := QueryPerformanceCounter(NewTimeStamp);
  NewLowPartSh   := _LARGE_INTEGER(NewTimeStamp).LowPart shr 1;
  StartLowPartSh := _LARGE_INTEGER(StartTimeStamp).LowPart shr 1;
  ElapsedCountSh := NewLowPartSh - StartLowPartSh;
  { answers from - $4000 0000 to +$3FFF FFFF, if -ve then assume timer wrapped }
  If ElapsedCountSh < 0 then ElapsedCountSh := ElapsedCountSh + $40000000;

  LastElapsedTimems := (ElapsedCountSh div msDivider) shl 1;
  Result := LastElapsedTimems;
end;

end.
