unit ULScriptu;

interface
uses
  SysUtils, Classes, {v0.47}Windows, Graphics, Controls, Forms, Dialogs,StdCtrls,
  ifspas, ifs_var, ifs_utl, ifs_obj,
  ULObjUsru, ULObju, TypInfo, PropUtl,
  {/v0.47 ifspas,}
  UlanGlob;

type
  TLogProc = procedure(s: string);

  TULScript = class(TCs2PascalScript)
    {FLogMemo: TMemo;}
    FLogProc: TLogProc;
    FULObjUsr: TULObjUsr;
    FAborted: boolean;
    {FScriptPath: string;}
    FCommandLine: string;
    function GetScriptsDirList: string;
    function GetParamCount: integer;
    function GetParamStr(i:integer): string;
    function GetNextParam(var ACommandLine: string; var AParam: string): boolean;
    procedure RegisterMethods;
  public
    constructor Create(id: Pointer; AULObjUsr: TULObjUsr);reintroduce;
    procedure Abort;
    procedure ObjSetStr(const AObjPath: string; const APropName: string; const AValue: string);
    function ObjGetStr(const AObjPath: string; const APropName: string): string;

    property LogProc: TLogProc read FLogProc write FLogProc;
    property ULObjUsr: TULObjUsr read FULObjUsr write FULObjUsr;
    property Aborted: boolean read FAborted;
    property ScriptsDirList: string read GetScriptsDirList;
    property CommandLine: string read FCommandLine write FCommandLine;
  end;

const
  IFSExt = '.IFS';

function ScriptsDir: string;
{getarraylength}

implementation
{v0.47}
uses
  ULScriptPaintFrm, ifpslib, ifsdfrm, ifsctrlstd, ifpscom, ifpstrans,
  ifpsdll, ifpsdelphi;
{/v0.47}

const
  FScriptsDir: string = '';

function ScriptsDir: string;
begin
  if FScriptsDir = '' then
    Result := DataDir + 'Scripts\'
  else
    Result := FScriptsDir;
end;

{v0.47}
function OnRunLine(id: Pointer; Sender: TIfPasScript; Position: Longint): TCs2Error;
begin
  Application.ProcessMessages;
  if (Sender is TULScript) and TULScript(Sender).Aborted{ULScriptForm.Tag = 2} then
    Result := EExitCommand
  else
    Result := Sender.ErrorCode;
end;

function RegProc(Sender: TIfPasScript; ScriptID: Pointer; proc: PProcedure; Params: PVariableManager; res: PIfVariant): TIfPasScriptError;
begin
  if proc^.Name = 'WRITELN' then begin
    if Sender is TULScript then with Sender as TULScript do begin
      if Assigned(FLogProc) then
        FLogProc(GetString(Vm_Get(Params, 0)));
    end;
  end else if proc^.Name = 'READLN' then begin
    GetVarLink(Vm_Get(Params, 0))^.Cv_Str := InputBox('Demo', 'Readln:', '');
  end else if proc^.Name = 'RANDOM' then begin
    SetInteger(res, random(GetInteger(Vm_Get(Params, 0))));
  end else if proc^.Name = 'PARAMCOUNT' then begin
    if Sender is TULScript then with Sender as TULScript do begin
      SetInteger(res, GetParamCount);
    end else begin
      SetInteger(res, 0);
    end;
  end else if proc^.Name = 'PARAMSTR' then begin
    if Sender is TULScript then with Sender as TULScript do begin
      SetString(res, GetParamStr(GetInteger(Vm_Get(Params, 0))));
    end else begin
      SetString(res ,'');
    end;
  end;
  Result := ENoError;
end;

function PaintRegProc(Sender: TIfPasScript; ScriptID: Pointer; proc: PProcedure; Params: PVariableManager; res: PIfVariant): TIfPasScriptError;
var
  I: Integer;
  r: TRect;
begin
  if proc^.Name = 'SHOWPAINTWINDOW' then begin
    PaintForm.ClientWidth := GetInteger(GetVarLink(Vm_Get(Params, 0)));
    PaintForm.ClientHeight := GetInteger(GetVarLink(Vm_Get(Params, 1)));
    PaintForm.Bitmap.Width := PaintForm.ClientWidth;
    PaintForm.Bitmap.Height := PaintForm.ClientHeight;
    PaintForm.Show;
    PaintForm.DoUpdate;
  end else if proc^.Name = 'HIDEPAINTWINDOW' then
    PaintForm.Hide
  else if proc^.Name = 'UPDATE' then begin
    PaintForm.DoUpdate;
    Application.ProcessMessages;
  end else if proc^.Name = 'CLEAR' then begin
    PaintForm.Bitmap.Canvas.Brush.Style := bsSolid;
    PaintForm.Bitmap.Canvas.Brush.Color := GetInteger(GetVarLink(Vm_Get(Params, 0)));
    PaintForm.Bitmap.Canvas.FillRect(Rect(0, 0, PaintForm.ClientWidth, PaintForm.ClientHeight));
  end else if proc^.Name = 'LINE' then begin
    PaintForm.Bitmap.Canvas.Pen.Color := GetInteger(GetVarLink(Vm_Get(Params, 4)));
    PaintForm.Bitmap.Canvas.MoveTo(GetInteger(GetVarLink(Vm_Get(Params, 0))), GetInteger(GetVarLink(Vm_Get(Params, 1))));
    PaintForm.Bitmap.Canvas.LineTo(GetInteger(GetVarLink(Vm_Get(Params, 2))), GetInteger(GetVarLink(Vm_Get(Params, 3))));
  end else if proc^.Name = 'CIRCLE' then begin
    PaintForm.Bitmap.Canvas.Pen.Color := GetInteger(GetVarLink(Vm_Get(Params, 3)));
    PaintForm.Bitmap.Canvas.Brush.Style := bsClear;
    I := GetInteger(GetVarLink(Vm_Get(Params, 2)));
    PaintForm.Bitmap.Canvas.Ellipse(GetInteger(GetVarLink(Vm_Get(Params, 0))) - I, GetInteger(GetVarLink(Vm_Get(Params, 1))) - I, GetInteger(GetVarLink(Vm_Get(Params, 0))) + I, GetInteger(GetVarLink(Vm_Get(Params, 1))) + I);
    ;
  end else if proc^.Name = 'RECTANGLE' then begin
    PaintForm.Bitmap.Canvas.Pen.Color := GetInteger(GetVarLink(Vm_Get(Params, 4)));
    PaintForm.Bitmap.Canvas.Rectangle(GetInteger(GetVarLink(Vm_Get(Params, 0))), GetInteger(GetVarLink(Vm_Get(Params, 1))), GetInteger(GetVarLink(Vm_Get(Params, 2))), GetInteger(GetVarLink(Vm_Get(Params, 3))));
  end else if proc^.Name = 'FILLEDRECTANGLE' then begin
    PaintForm.Bitmap.Canvas.Brush.Style := bsSolid;
    PaintForm.Bitmap.Canvas.Brush.Color := GetInteger(GetVarLink(Vm_Get(Params, 4)));
    r := Rect(GetInteger(GetVarLink(Vm_Get(Params, 0))), GetInteger(GetVarLink(Vm_Get(Params, 1))), GetInteger(GetVarLink(Vm_Get(Params, 2))), GetInteger(GetVarLink(Vm_Get(Params, 3))));
    PaintForm.Bitmap.Canvas.FillRect(r);
  end;
  Result := ENoError;
end;

function ImportTest(S1: string; s2: Longint; s3: Byte; s4: word; var s5: string): string;
begin
  Result := s1 + ' ' + IntToStr(s2) + ' ' + IntToStr(s3) + ' ' + IntToStr(s4) + ' - OK!';
  S5 := result + ' - OK2!';
end;

function OnUses(id: Pointer; Sender: TIfPasScript; Name: string): TCs2Error;
var
  f: TIFPasScript;
  n: TFileStream;
  s: string;
  {v0.47}
  fn: string;
  {/v0.47}
begin
  if Name = 'SYSTEM' then begin
    RegisterStdLib(Sender, False);
    RegisterTIfStringList(Sender);
    RegisterComLibrary(Sender);
    RegisterTransLibrary(Sender);
    RegisterFormsLibrary(Sender);
    RegisterStdControlsLibrary(Sender);
    RegisterDllCallLibrary(Sender);
    RegisterDelphiFunction(Sender, 'function ImportTest(S1:string;s2:Longint;s3:Byte;s4:Word;var s5:string):string;', @importTest);
    Sender.AddFunction(@RegProc, 'procedure Writeln(s: string)', nil);
    Sender.AddFunction(@RegProc, 'procedure Readln(var s: string)', nil);
    Sender.AddFunction(@RegProc, 'function Random(I: Longint): Longint', nil);
    {v0.47}
    Sender.AddFunction(@RegProc, 'function ParamCount: integer', nil);
    Sender.AddFunction(@RegProc, 'function ParamStr(i: integer): string', nil);
    if Sender is TULScript then with Sender as TULScript do
      RegisterMethods;
    {/v0.47}
    Result := ENoError;
  end else if Name = 'GRAPH' then begin
    Sender.AddFunction(@PaintRegProc, 'procedure ShowPaintWindow(x,y : integer)', nil);
    Sender.AddFunction(@PaintRegProc, 'procedure Clear(Color: Integer);', nil);
    Sender.AddFunction(@PaintRegProc, 'procedure Update;', nil);
    Sender.AddFunction(@PaintRegProc, 'procedure Line(x1,y1,x2,y2,color: Integer);', nil);
    Sender.AddFunction(@PaintRegProc, 'procedure Circle(x,y,r,color: Integer);', nil);
    Sender.AddFunction(@PaintRegProc, 'procedure Rectangle(x1,y1,x2,y2,color: Integer);', nil);
    Sender.AddFunction(@PaintRegProc, 'procedure FilledRectangle(x1,y1,x2,y2,color: Integer);', nil);
    Sender.AddFunction(@PaintRegProc, 'procedure HidePaintWindow;', nil);
    Result := ENoError;
  end else
  begin
    F := TIFPasScript.Create(nil);
    try
      if Sender is TULScript then with Sender as TULScript do begin
        fn := FileSearch(ScriptsDirList, Name + IFSExt);
      end else begin
        fn := Name + IFSExt;
      end;
      n := TFileStream.Create({v0.47}fn{/v0.47 Name+ IFSExt}, FMOpenRead or FMShareDenyWrite);
      SetLength(s, n.Size);
      n.Read(s[1], Length(S));
      n.Free;
    except
      Result := EUnitNotFound;
      exit;
    end;
    f.OnUses := ULScriptu.OnUses;
    f.SetText(s);
    if f.ErrorCode <> ENoError then
    begin
      Sender.RunError2(f, f.ErrorCode, f.ErrorString);
      f.Free;
      Result := EUnitNotFound;
    end else
    begin
      if not Sender.Attach(F) then
      begin
        f.Free;
        Result := ECustomError;
      end else
        Result := ENoError;
    end;
  end;
end;
{/v0.47}

constructor TULScript.Create(id: Pointer; AULObjUsr: TULObjUsr);
begin
  inherited Create(id);
  OnRunLine := ULScriptu.OnRunLine;
  OnUses := ULScriptu.OnUses;
  MaxBeginNesting := 1000;
  FULObjUsr := AULObjUsr;
end;

procedure TULScript.Abort;
begin
  FAborted := true;
end;

function TULScript.GetScriptsDirList: string;
begin
  Result := ScriptsDir;
end;

procedure StripQuotes(var AttrValue: string);{from attrib}
begin
  if (AttrValue <> '') and (AttrValue[length(AttrValue)] = '"') then
    SetLength(AttrValue, length(AttrValue) - 1);
  if (AttrValue <> '') and (AttrValue[1] = '"') then begin
    AttrValue := copy(AttrValue, 2, length(AttrValue));
  end;
end;

function TULScript.GetNextParam(var ACommandLine: string; var AParam: string): boolean;
var
  p: integer;
  t: string;
  isInQuotes:boolean;
begin
  Result := false;
  AParam := '';
  ACommandLine := trim(ACommandLine);
  if ACommandLine = '' then
    exit;
  isInQuotes := false;
  p := 1;
  while (p <= length(ACommandLine)) do begin
    if (ACommandLine[p] = ' ') and (not isInQuotes) then
      break;
    if ACommandLine[p] = '"' then
      isInQuotes := not isInQuotes;
    inc(p);
  end;
  AParam := copy(ACommandLine, 1, p - 1);
  ACommandLine := copy(ACommandLine, p + 1, length(CommandLine));
  StripQuotes(AParam);
  Result := AParam <> '';
end;

function TULScript.GetParamCount: integer;
var
  s: string;
  p: string;
begin
  Result := 0;
  s := CommandLine;
  while GetNextParam(s, p) do inc(Result);
  if Result > 0 then
    Dec(Result);
end;

function TULScript.GetParamStr(i:integer): string;
var
  j: integer;
  s: string;
  p: string;
begin
  Result := '';
  s := CommandLine;
  j := 0;
  while GetNextParam(s, p) do begin
    if j = i then begin
      Result := p;
      exit;
    end;
    inc(j);
  end;
end;


function RegMethodsProc(Sender: TULScript{TIfPasScript}; ScriptID: Pointer; proc: PProcedure; Params: PVariableManager; res: PIfVariant): TIfPasScriptError;
begin
  if proc^.Name = 'OBJSETSTR' then begin
     Sender.ObjSetStr(
       GetString(Vm_Get(Params, 0)),
       GetString(Vm_Get(Params, 1)),
       GetString(Vm_Get(Params, 2))
     );
  end else if proc^.Name = 'OBJGETSTR' then begin
    SetString(res, Sender.ObjGetStr
      (
        GetString(Vm_Get(Params, 0)),
        GetString(Vm_Get(Params, 1))
      )
    );
  end;
  Result := ENoError;
end;

procedure TULScript.RegisterMethods;
begin
  AddFunction(@RegMethodsProc, 'procedure ObjSetStr(AObjPath: string; APropName: string; AValue: string)', nil);
  AddFunction(@RegMethodsProc, 'function ObjGetStr(AObjPath: string; APropName: string): string', nil);
end;


function ULObjFindPropInfo(const AObjPath: string; const APropName: string; var AObject: TObject; var APropInfo: PPropInfo): boolean;
var
  o: TULObj;
  f: TULObjField;
  ou: TObject;
begin
  Result := false;
  AObject := nil;
  APropInfo := nil;
  if not ULFKeeper.FindByULObjPath(AObjPath, 0, o) then
    exit;
  if o <> nil then begin
    if not o.HasField(APropName, f) then begin
      if not o.HasUsrWithProp(APropName, ou, APropInfo) then
        exit;
      AObject := ou;
      Result := true;
    end else begin
      AObject := o;
      APropInfo := f.FldDesc.PropInfo;
      Result := true;
    end;
  end;
end;


procedure TULScript.ObjSetStr(const AObjPath: string; const APropName: string; const AValue: string);
var
  o: TObject;
  pi: PPropInfo;
begin
  if ULObjFindPropInfo(AObjPath, APropName, o, pi) then begin
    ClassSetPropStr(o, pi, AValue);
  end;
end;
{ulobjctrl}


function TULScript.ObjGetStr(const AObjPath: string; const APropName: string): string;
var
  o: TObject;
  pi: PPropInfo;
begin
  Result := '';
  if ULObjFindPropInfo(AObjPath, APropName, o, pi) then
    Result := ClassGetPropStr(o, pi);
end;

{/TULScript.}
end.
