unit AAAType;
  { Amino Acid Analyser info - defaults, status,.. }
interface
uses
  UlanType, ULRecTyp; {ulanrecs.lst aaau}
const
  AAAExt = '.AAA';
  AAAID = ord('A') + 256* ord('A') + 256 * 256 * ord('A');

type
  TAAAName = string[40];
  TAAADesc = string;
  TThermostatState = (tsOff, tsOn);
  TAAAState = (
    aasDisconnected,
    aasAborted,
    aasFinished,
    aasStandby,
    aasOff,   {.. not real state, just for comparing }
    aasStarting,
    aasStopping,
    aasFinishing,
    aasAborting,
    aasReady,
    aasStopRunning,
    aasRunning
    );

  TAAARec = packed record {<Caption="Amino Acid Analyser" RootChild=1
     HasRecName=1 EditModal=1 Enabled=1 Visible=1 ChildRecIDs=ULIID
     Uses=ULIType
     Create1=" AAAName := 'AAA';">}
    Head: TULRecHead;
    Info: TULRecInfo;
    AAAName:TAAAName;{<NonVisible=1 Hint="Name of the AAA setup">}
      { Name of the AAA setup. ulatype }
    AAADesc:TAAADesc;{<NonVisible=1 Caption="AAA Desc." Hint="Description of the AAA setup">}
      { Longer description of the AAA setup. }
    SeqsDir: string;{<Enabled=1 Caption="Sequences directory"
      Hint="Directory for new sequence files/directories" Type=Dir>}
    PrgsDir: string;{<Enabled=1 Caption="Programs directory"
      Hint="Directory for program files" Type=Dir>}
    MethodsDir: string;{<Enabled=1 Caption="Methods directory"
      Hint="Directory for method files" Type=Dir>}
    SeqFileName: string;{<Enabled=1 Caption="Current Sequence" Type=FileName
      Filter="Sequences (*.ULS)|*.ULS"
      Hint="File name of the current sequence">}
    PrgFileName: string;{<Enabled=1 Caption="Default Prog.Name" Type=FileName
      Filter="Programs (*.AAP)|*.AAP"
      Hint="Default AA Program file for new sequence">}
    MethodFileName: string;{<Enabled=1 Caption="Default mehod for new sequence"
      Filter="Methods (*.ULM)|*.ULM" Type=FileName>}
      { SETUP VALUES }
    P1_FLOW: TFlowRate;{<Enabled=1 UserCoef=1000 NumDec=2 Caption="P1 Flow[ml/min]"
      DefVal=300>}
      { Requested flowrate on pump1 }
    P1_PRESS_L: TPressure;{<Enabled=1 UserCoef=10 NumDec=1 Caption="P1 Press Min[MPa]"
      DefVal=10>}
      { Minimal allowed pressure on pump1 }
    P1_PRESS_H: TFlowRate;{<Enabled=1 UserCoef=10 NumDec=1 Caption="P1 Press Max[MPa]"
      DefVal=70>}
      { Maximal allowed pressure on pump1 }
    P1PressDev: TDeviation;{<Enabled=1 Caption="P1 Deviation[%]" DefVal=10>}
      { Allowed deviation of pressure on pump1 (in %) }

    P2_FLOW: TFlowRate;{<Enabled=1 UserCoef=1000 NumDec=2 Caption="P2 Flow[ml/min]"
      DefVal=200>}
      { Requested flowrate on pump2 }
    P2_PRESS_L: TPressure;{<Enabled=1 UserCoef=10 NumDec=1 Caption="P2 Press Min[MPa]"
      DefVal=0>}
      { Minimal allowed pressure on pump2 }
    P2_PRESS_H: TFlowRate;{<Enabled=1 UserCoef=10 NumDec=1 Caption="P2 Press Max[MPa]"
      DefVal=40>}
      { Maximal allowed pressure on pump2 }
    P2PressDev: TDeviation;{<Enabled=1 Caption="P2 Deviation[%]" DefVal=30>}
      { Allowed deviation of pressure on pump2 (in %) }

    AS_TEMP1RQ: TTemperature;{<Enabled=1 UserCoef=10 NumDec=2 Caption="Column Temp.[C]"
      DefVal=500>}
      { Requested temperature in autosampler (column) }
    AsTempMinDif: TTemperature;{<Enabled=1 UserCoef=10 NumDec=2
      Hint="Substracting this from Column.Temp. gives minimal allowed temp."
      Caption="Col.Temp.Min-Dif[C]" DefVal=50 >}
      { Minimal allowed temperature in autosampler, given by max. allowed (abs.)
        difference from Column.Temp. }
    AsTempMaxDif: TTemperature;{<Enabled=1 UserCoef=10 NumDec=2
      Hint="Adding this to Column.Temp. gives maximal allowed temp."
      Caption="Col.Temp.Max-Dif[C]" DefVal=50>}
      { Maximal allowed temperature in autosampler, given by max. allowed (abs.)
        difference from Column.Temp. }
    AsTempDev: TDeviation;{<Enabled=1 Caption="Column Temp.Dev.[%]" DefVal=10>}

    DET_TEMP1RQ: TTemperature;{<Enabled=1 UserCoef=10 NumDec=2 DefVal=1000
      Hint="Requested temperature in reactor"
      Caption="React.Temp.[C]">}
      { Requested temperature in detector (reactor) }
      { Switch termostat off }
    DetTempMinDif: TTemperature;{<Enabled=1 UserCoef=10 NumDec=2
      Caption="React.Temp.Min-Dif[C]" DefVal=50
      Hint="Substracting this from React.Temp. gives minimal allowed temp.">}
      { Minimal allowed temperature in detector, given by max. allowed difference
        from React.Temp. }
    DetTempMaxDif: TTemperature;{<Enabled=1 UserCoef=10 NumDec=2
      Caption="React.Temp.Max-Dif[C]" DefVal=50
      Hint="Adding this to React.Temp. gives maximal allowed temp.">}
      { Maximal allowed temperature in detector, given by max. allowed difference
        from React.Temp. }
    DetTempDev: TDeviation;{<Enabled=1 Caption="React.Temp.Dev.[%]" DefVal=10>}
    AAAState: TAAAState;{<NonVisible=1>}
    PumpStartInhibit: boolean;{<NonVisible=1>}
      { if on, the pumps won't start automatically }
  end;
  PAAARec = ^TAAARec;

(*
      { CURRENT VALUES (runtime) }
    AS_TEMP_ST: TThermostatState;{<Caption="Column Thermostat State NonVisible=1>}
      { Is termostat at autosampler ON(off)? }
    AS_TEMP_ON: TCommand;{<Caption="Switch Column Thermostat ON" NonVisible=1>}
      { Switch column thermostat on }
    AS_TEMP_OFF: TCommand;{<Caption="Switch Column Thermostat OFF" NonVisible=1>}
      { Switch column thermostat off }

    DET_TEMP_ST: TThermostatState;{<Caption="Column Thermostat State NonVisible=1>}
      { Is termostat at detector ON? }
    DET_TEMP_ON: TCommand;{<Caption="Switch Reactor Thermostat ON" NonVisible=1>}
      { Switch reactor thermostat on }
    DET_TEMP_OFF: TCommand;{<Caption="Switch Reactor Thermostat OFF" NonVisible=1>}
      { Switch reactor thermostat off }
    StartTime: integer;
      { At what computer time [ms] was the autosamler started }
*)

implementation

end.
