unit ULSRType;
  { Ulan Sequence, source for MakeComp program }
interface
uses
  SysUtils, Classes, UlanType, ULRecTyp;
const
  ULSRID = ord('U') + 256* ord('L') + 256 * 256 * ord('S') + 256 * 256 * 256 * ord('R');

                   {ulsqtype}
type
  TSampleState = (
    sasWaiting,    { sample waiting for processing }
    sasInLoop,     { sample loaded to injector valve }
    sasRunning,    { sample injected }
    sasCompleting, { sample acquisition stopped, equilibrating }
    sasDone,       { sample finished }
    sasError       { sample finished, during processing of the sample some
                     error encountered }
  );

  TULSRRec = packed record {<Caption="Sample" HasRecName=1
    ChildRecIDs=ULIID,ULMID,AAPGID BrowseChildRecIDs=0
    BrowseFieldList=VialNr,FileName,SampleState,PrgFileName,MethodFileName,MultiplyFactor,DivideFactor,CalibrationStandard,SampleName,SampleDesc,Date,UserName
    Uses=ULMType,ULIType,AAPGType Enabled=1 Visible=1 EditModal=1
    Create1="DateTime := DateTimeToFileDate(Now);">}
    Head: TULRecHead; {ulatype}
    Info: TULRecInfo;
    SampleName: TSampleName;{<Enabled=1 Hint="Sample name (usually unique in the sequence)">}
      { Name of the sample. }
    SampleNr: integer;{<Caption="Sample Nr." Hint="Automatically assigned sample order number">}
      { order number in the sequence, assigned automatically,
        can be changed if was not processed yet (if inserted new sample before it) }
    VialNr: integer;{<Enabled=1 Caption="Vial Nr."
      Hint="Number of the sample position in the autosampler">}
    SampleDesc: TSampleDesc;{<Enabled=1 Caption="Sample Desc."
      Hint="Longer description of the sample">}
      { Longer description of the sample. }
    DateTime: longint;{<Caption="Date" Type=FileDateTime Enabled=1
      Hint="Date/Time when the sample was added to sequence">}
    UserName: TUserName;{<Enabled=1 Hint="Name of the person who made the analysis">}
      { Short name of the analyst (copy from ulu file, for the case the UserID
        record will be deleted from ulu file). }
    FileName: TFileName;{<Enabled=1 Caption="File name"
      Hint="Name for the file with acquired data">}
      { Name of the file (in sequence directory) where the acquired data
        for this sample should be stored. Created automatically, can be changed
        by user. }
    PrgFileName: TFileName;{<Enabled=1 Caption="Program name" Type=FileName
      Hint="Name of the file with AAA program"
      Filter="AA Analyser Program (*.AAP)|*.AAP">}
    SampleState: TSampleState;{<Caption=State Hint="Current state of the sample"
      Colors=clWhite,clGreen,clBlack,clYellow,clBlack,clWhite,clBlack,clGray,clBlack,clGray,clWhite,clRed
      StripPrefix=sas>}
      { State of the sample during processing, pairs of colors correspond to
        states - sasWaiting,sasInLoop,sasRunning,sasCompleting,sasDone,sasError
        see TColor }
    MethodFileName: TFileName;{<Enabled=1 Caption="Method name" Type=FileName
      Hint="Name of method file (used for acquired data evaluation)"
      Filter="Method (*.ULM)|*.ULM">}
    ProgramLoad: TNotifyEvent;{<Caption="Load Program" Type=Method>}
    ProgramEdit: TNotifyEvent;{<Caption="Modify Program" Type=Method>}
    ProgramSave: TNotifyEvent;{<Caption="Save Program"
      Hint="Save Program info to file" Type=Method>}
    MethodLoad: TNotifyEvent;{<Caption="Load Method"
      Hint="Load method info from file" Type=Method>}
    MethodEdit: TNotifyEvent;{<Caption="Modify Method"
      Hint="Modify Method information" Type=Method>}
    MethodSave: TNotifyEvent;{<Caption="Save Method"
      Hint="Save method info to file" Type=Method>}
    MultiplyFactor: TFactor;{<Enabled=1 DefVal=1 Hint="Used to multiply results with" Caption="Mult.factor">}
      { Can be different for each sample, used to multiply results with, together
        with method Factor. Introduced in Chromulan v0.25.}
    DivideFactor: TFactor;{<Enabled=1 DefVal=1 Hint="Used to divide results with" Caption="Dif.factor">}
    CalibrationStandard: boolean;{<Enabled=1 Caption="Cal.std." Hint="Will be this sample used as calibration standard?">}
     { Is this analysis beeing used as calibration standard? }
    Protocol: string;{<Enabled=1 Type=Memo Hint="Eventual unusual events during acquisition logged here">}
  end;
  PULSRRec = ^TULSRRec;

  (*
    Active: boolean;
      { If true then controlled by software otherwise by sampler }
    ActionOnSignal: TActionOnSignal;
      { what to do upon signal from device }
    Duration: single;
      { default duration of one analysis (see ulitype) in seconds }
    IdleTime: single;
      { interval between samples (end of first - start of second) in seconds }
    Status: TSequenceStatus;
      { in what run status is the sequence }
    VialNr: integer;
      { what is the current sample (vial in autosamlper), 0 if none }
    FileMask: string;
      { how should look file names for acquired data of each run }
  *)

implementation

end.
