unit UlanGlob;
{ global variables/parameters for Ulan program, for constant values/types see
  ulantype.pas }
interface
uses
  Windows, Classes, SysUtils,
  MyType, {v0.48}UtlType,{/v0.48 ConfType, }UlanType, ULDrvTyp, Confu, ApexType{v0.29}, WinUtl{/v0.29};

{Exceptions}
type
  ENotImplemented = class(Exception);
    { The feature was not implemented yet }
  EInvalidParams = class(Exception);
    { Procedure called with invalid input parameters }
  EInvalidFileExt = class(Exception);
    { Filename with unsupported extension was tried to open (for reading) }
  EOnlyULFSupported = class(Exception);
    { Trying to create analysis with file name with extension different from .ULF }
  EAcqAlreadyOpened = class(Exception);
    { Trying to opened new chromagram window (for acquisition), but it was
      already opened for current channel. }
  EImportAborted = class(Exception);
    { When importing TXT file, the chance to change import parameters is
      given to user, if he presses Cancel, this exception is raised. }
  EDataOpenFailed = class(Exception);
{/Exception}

const
{ini.lst}
  DefPortName: shortstring = 'COM2';
    { what is the default port for communication }
  DefDeviceMode: TDeviceMode = dmUlan;
    { Set to dmUlan or dmApex, defines default type of
      communication with Pikron devices.
      dmUlan by default, if not running under NT/2000 get adjusted to
      dmApex after warning the user.
      Can be changed back in Setup|Options dialog.
      Copied to CurDeviceMode after reading from ini, CurDeviceMode
      is copied back to DefDeviceMode before writing to ini  }
  DefUVDetAddr:longint = 3;
    { What is the default address of UV detector in ulan network }
  {v1.05}
  DefFilterType: TFilterType =  ftNone;
    { what filtering scheme is beeing used to display the spectrum,
      see ulantype.ftXXXX }
  DefAvgPointCount: longint = 5;
    { what number of points is used for averaging if FilterType = ftAvg }
  DefFilter1: single = 0.5;
    { what is the value of cofficient used to display the spectrum if
      FilterType = ftFilter1 }
  {/v1.05}
  DefaultAnalysisName: shortstring = {v0.13}'DEFAULT.ULT';{/v0.13 'DEFANAL.ULF';}
  VerifyAbort: boolean = true;
    { Ask user if the abortion of the acquisition or discarding of
      acquired data is really what he wants to do if he trying to close the
      window with running acquisition or acquired but not saved data. }

  ToolsAllowed: boolean = false;
  DebugToolsAllowed: boolean = false;
  TestAllowed: boolean = false;

  {v0.22 moved to ULObju}
  {/v0.22
  UserMode: TUserMode = umUser;{umSysOp}
    { behavior of some procedures behaves according this param.
      see ulantype umXXXX }
  MaxULAddr: integer = 10;
    { How many ulan device addresses should be scanned during autodetect. }
  {v0.22 moved to ULBrowu}
  {/v0.22
  AutoSizeBrowseCols : boolean = true;}
  AutoConfigDriver: boolean = true;
    { Try to install ul_drv.sys automatically? Disable if makes troubles. }
  PCUlanAddr: integer = 2;
  IniDataDir: shortstring = 'DATA\';
    { copied to DataDir expanded }
  IniTemplateDir: shortstring = 'Templates\';
    { copied to TemplateDir expanded }
  {v0.41}
  IniMethodDir: shortstring = 'DATA\Methods\';
  IniSequenceDir: shortstring = 'DATA\Sequences\';
  IniPrgDir: shortstring = 'DATA\Programs\';
  {/v0.41}
  ReportDir: shortstring = '';
  BaseSplittingAllowed: boolean = false;{true;{ create baseline allows splitting existing
    baseline, then size neighboring baseline sections together }
  UlanPointTimeInterval: single = 40;{ms}
    { sampling rate 25 Hz }
  {v0.11}{/v0.11 GHLabPointTimeInterval: single = 31.25;{ms}
  {v0.09}
  PeakOverlapAllowed: boolean = false;{true;}
  {/v0.09}

  {v0.14}
  DefAnalTemplate: shortstring = '';
    { Updated, loaded and saved from FileNewDlg; file name of the template
      to be used for the new analysis }
  {/v0.14}
  {v0.41}
  DefAnalSeq: shortstring = '';
  {/v0.41}
  
  {v0.18}
  MaxSpectrumFormCount: integer = 4;
    {max allowed number of spectrum windows}
  {/v0.18}
  {v0.24}
  DefaultApplication: shortstring = 'None';
    { can only have one of the values specified in DevSetFr.DefAppComboBox.Items:
      None
      AAA }
  {/v0.24}

  {v0.28}
  UseLanguage: boolean = false;
  LanguageName: shortstring = '';
  {/v0.28}
  {v0.29}
  RootUsrDir: shortstring = '';
    { root for all data, ini, etc., the dir where is the INI file }
  {/v0.29}
  {v0.45}
  AutofixData: boolean = false;
    { check every opened data ULF file for natural time sequence of data points }
  {/v0.45}
{/ini.lst}
  {v0.14}
  TemplateDir: shortstring = '';
  {/v0.14}
  {v0.41}
  MethodDir: shortstring = '';
  SequenceDir: shortstring = '';
  PrgDir: shortstring = '';
  {/v0.41}

  {v0.13}
  DataDir: shortstring = '';
  {/v0.13}
  PortAddr: {v0.11}integer {/v0.11 word} = $2f8;
    { default serial port address used to create ul_drv.req }
  PortIrq: {v0.11}integer{/v0.11 byte} = 3;
    { default irq used to create ul_drv.req }
  {v0.21}
  UlanBaudRate: integer = $2580;{=9600}
    { default baud rate to create ul_drv.req }
  {/v0.21}

  MinXStep = 0.1; { in seconds }
  MinYStep = 0.0001;

  MinUserYStep = MinYStep;
    { Minimal allowed Y difference of two points, in user units (same
      as exp units - AU) }
  MinUserXStep = MinXStep / 60;
    { Minimal allowed X difference of two points, in user units (minutes) }

  CurFilterPars: TFilterPars = (
    FilterType : ftNone;
    AvgPointCount : 5;
    Filter1 : 0.5);
    { updated as default from OK click in FILTDLG.PAS,
      used as default in SPECTRUM.PAS apexpoints.create }

  CurDeviceMode: TDeviceMode = dmUnspecified;
    { set after reading ini file to DefDeviceMode or can be set by
      other objects to something else if the created specform
      should use another type of device;
     Used only in DevSetFr now (v0.14) }

  CurPortName:shortstring = 'COM2';
  CurUVDetAddr:longint = 3;

  CurUserViewLimit: TUserViewLimit = (
   Min:(X:0;Y:{v0.15}DefMinUsrYValue{/v0.15 -0.1});Max:(X:20;Y:{v0.13}DefMaxAcqYValue{/v0.13 2})
  );
  NewUserViewLimit: TUserViewLimit = (
   Min:(X:0;Y:{v0.15}DefMinUsrYValue{/v0.15 -0.1});Max:(X:20;Y:{v0.13}DefMaxAcqYValue{/v0.13 2})
  );

  OverlayMode: boolean = false;
    { Can change at runtime only. If set true, then next opened chromatogram
      file will be added to active chromatogram. }
  {v0.23}
  AAAAutoAssignDefNames: boolean = true;
  {/v0.23}

{ Runtime only (not from INI) }
{v0.41}
const
  AAAActive: boolean = false;
{/v0.41}

var
  OSVersion:OSVERSIONINFO;
    { initialized upon call to UlanConfigRead
      DWORD dwOSVersionInfoSize;
      DWORD dwMajorVersion;
      DWORD dwMinorVersion;
      DWORD dwBuildNumber;
      DWORD dwPlatformId;
          VER_PLATFORM_WIN32s	        Win32s on Windows 3.1.
          VER_PLATFORM_WIN32_WINDOWS	Win32 on Windows 95.
          VER_PLATFORM_WIN32_NT	        Win32 on Windows NT.
      TCHAR szCSDVersion[ 128 ];
    }

procedure UlanConfigReadWrite(rw:TReadWrite);

implementation
{v0.22}
uses
  ULObju{v0.24}{/v0.24, ULBrowu};
{/v0.22}

procedure UlanConfigReadWrite(rw:TReadWrite);
begin
  if rw = rwWrite then begin
    DefDeviceMode := CurDeviceMode;
    DefPortName := CurPortName;
    DefUVDetAddr := CurUVDetAddr;

    DefFilterType := CurFilterPars.FilterType;
    DefAvgPointCount := CurFilterPars.AvgPointCount;
    DefFilter1 := CurFilterPars.Filter1;
  end;
  {v0.29}
  RootUsrDir := ExtractFileDir(ConfigFileName);
  {/v0.29}

  ConfigReadWriteValue(rw, DevSection, 'DefPortName', @DefPortName, ptString);
  ConfigReadWriteValue(rw, DevSection, 'DevMode', @DefDeviceMode, ptByte);
  ConfigReadWriteValue(rw, DevSection, 'UVDetAddr', @DefUVDetAddr, ptLongint);
  ConfigReadWriteValue(rw, DevSection, 'MaxULAddr', @MaxULAddr, ptLongint);
  {v0.21}
  ConfigReadWriteValue(rw, DevSection, 'AutoConfigDriver', @AutoConfigDriver, ptByte);
  {/v0.21}

  {v0.11 now values for ul_drv reading/writing only from/to Registry}
  {/v0.11
  ConfigReadWriteValue(rw, DevSection, 'PortAddr', @PortAddr, ptWord);
  ConfigReadWriteValue(rw, DevSection, 'PortIrq', @PortIrq, ptByte);
  ConfigReadWriteValue(rw, DevSection, 'PCUlanAddr', @PCUlanAddr, ptLongint);}

  ConfigReadWriteValue(rw, DevSection, 'UlanPointTimeInterval', @UlanPointTimeInterval, ptSingle);
  {v0.08}
  {v0.11}{/v0.11
  ConfigReadWriteValue(rw, DevSection, 'GHLabPointTimeInterval', @GHLabPointTimeInterval, ptSingle);}
  {/v0.08}
  ConfigReadWriteValue(rw, SpecSection, 'FilterType', @DefFilterType, ptByte);
  ConfigReadWriteValue(rw, SpecSection, 'AvgPointCount', @DefAvgPointCount, ptLongint);
  ConfigReadWriteValue(rw, SpecSection, 'Filter1', @DefFilter1, ptSingle);
  ConfigReadWriteValue(rw, SpecSection, 'IniDataDir', @IniDataDir, ptString);
  ConfigReadWriteValue(rw, SpecSection, 'IniTemplateDir', @IniTemplateDir, ptString);
  {v0.41}
  ConfigReadWriteValue(rw, SpecSection, 'IniMethodDir', @IniMethodDir, ptString);
  ConfigReadWriteValue(rw, SpecSection, 'IniSequenceDir', @IniSequenceDir, ptString);
  ConfigReadWriteValue(rw, SpecSection, 'IniPrgDir', @IniPrgDir, ptString);
  {/v0.41}

  ConfigReadWriteValue(rw, SpecSection, 'MinX', @CurUserViewLimit.Min.X, ptSingle);
  ConfigReadWriteValue(rw, SpecSection, 'MaxX', @CurUserViewLimit.Max.X, ptSingle);
  ConfigReadWriteValue(rw, SpecSection, 'MinY', @CurUserViewLimit.Min.Y, ptSingle);
  ConfigReadWriteValue(rw, SpecSection, 'MaxY', @CurUserViewLimit.Max.Y, ptSingle);
  ConfigReadWriteValue(rw, SpecSection, 'DefaultAnal', @DefaultAnalysisName, ptString);
  {v0.18}
  ConfigReadWriteValue(rw, SpecSection, 'MaxSpectrumFormCount', @MaxSpectrumFormCount, ptLongint);
  {/v0.18}


  ConfigReadWriteValue(rw, EnvSectionName, 'ToolsAllowed', @ToolsAllowed, ptByte);
  ConfigReadWriteValue(rw, EnvSectionName, 'DebugToolsAllowed', @DebugToolsAllowed, ptByte);
  ConfigReadWriteValue(rw, EnvSectionName, 'TestAllowed', @TestAllowed, ptByte);
  ConfigReadWriteValue(rw, EnvSectionName, 'UserMode', @UserMode, ptByte);
  {v0.24}
  ConfigReadWriteValue(rw, EnvSectionName, 'DefaultApplication', @DefaultApplication, ptString);
  {/v0.24
    ConfigReadWriteValue(rw, EnvSectionName, 'AutoSizeBrowCols', @AutoSizeBrowseCols, ptByte);}
  {v0.41}
  ConfigReadWriteValue(rw, EnvSectionName, 'AAAAutoAssignDefNames', @AAAAutoAssignDefNames, ptByte);
  {/v0.41}
  {v0.45}
  ConfigReadWriteValue(rw, EnvSectionName, 'AutofixData', @AutofixData, ptByte);
  {/v0.45}

  {v0.28}
{  ConfigReadWriteValue(rw, EnvSectionName, 'UseLanguage', @UseLanguage, ptByte);
  ConfigReadWriteValue(rw, EnvSectionName, 'LanguageName', @LanguageName, ptString);}
  {/v0.28}

  if rw = rwRead then begin
    CurDeviceMode := DefDeviceMode;
    CurPortName := DefPortName;
    CurUVDetAddr := DefUVDetAddr;

    CurFilterPars.FilterType := DefFilterType;
    CurFilterPars.AvgPointCount := DefAvgPointCount;
    CurFilterPars.Filter1 := DefFilter1;

    OSVersion.dwOSVersionInfoSize := sizeof(OSVersion);
    GetVersionEx(OSVersion);
      { checking for OSVersion.dwPlatformID = VER_PLATFORM_WIN32_NT
        if dmUlan wanted }
    {v0.29}
    DataDir := AbsoluteFileName(RootUsrDir, IniDataDir{v0.36},''{/v0.36});
    TemplateDir := AbsoluteFileName(RootUsrDir, IniTemplateDir{v0.36},''{/v0.36});
    {/v0.29
    DataDir := ExpandFileName(IniDataDir);
    TemplateDir := ExpandFileName(IniTemplateDir);}
    CreateDir(DataDir);
    CreateDir(TemplateDir);
    {/v0.14}

    {v0.41}
    MethodDir := AbsoluteFileName(RootUsrDir, IniMethodDir, '');
    CreateDir(MethodDir);
    SequenceDir := AbsoluteFileName(RootUsrDir, IniSequenceDir, '');
    CreateDir(SequenceDir);
    PrgDir := AbsoluteFileName(RootUsrDir, IniPrgDir, '');
    CreateDir(PrgDir);
    {/v0.41}
  end;                                         {ulmtype}
end;

initialization
  ConfigSetGlobals(nil, 0);
  if ReportDir = '' then
    ReportDir := ExtractFilePath(Paramstr(0));
  {v0.13}
  DecimalSeparator := '.';
  {/v0.13}
end.
