unit Pswdu;
interface
uses
  PswdDlg, Desu, Language, Msgu;

function PasswordCheck: boolean;
  { Checks if password requiered:
      if yes (i.e. some password was set by EncryptedPasswordSet method
              or using PasswordChange method),
         checks if already entered ,
           if not entered yet prompts for it,
             if not entered correctly returns false
             if entered correctly returns true
           if entered previously returns true
      if no, returns true }

procedure PasswordChange;
  { invokes dialog for changing a password }

procedure EncryptedPasswordSet(const APassword: string);
  { use to set value from e.g. ini file }

function EncryptedPasswordGet: string;
  { use to get value for storing in ini file }

implementation

type
  TPasswordString = string[20];
const
  EncryptedPassword : TPasswordString = '';
  PasswordEntered: boolean = false;

function EncryptPassword(s:string):string;
var e:string;
  k:string[20];
begin
  e := s;
  k := 'a;ls493ru';
  {desu}EncryptBuffer(s[1], e[1], length(s), k[1], length(k));
  EncryptPassword := e;
end;

function PasswordCheck: boolean;
var s:string;
begin
  Result := false;
  if EncryptedPassword = '' then begin
    PasswordEntered := true;
    Result := true;
    exit;
  end;
  if not PasswordEntered then begin
    repeat
      if not EnterPassword('',s) then
        exit;
    until EncryptPassword(s) = EncryptedPassword;
    PasswordEntered := true;
  end;
  Result := true;
end;

procedure PasswordChange;
var
  s, s1: string;
begin
  if not PasswordCheck then
    exit;
  repeat
    if not EnterPassword(GetTxt({#}'Enter new password'), s) then
      exit; {'Zadejte nov heslo'}
    if not EnterPassword(GetTxt({#}'Enter new password again'), s1) then
      exit; {'Zadejte podruh nov heslo'}
    if s <> s1 then begin
      ShowMessage(GetTxt({#}'Error, enter new password again'), smError, 0);
         {Chyba, zadejte znovu nov heslo'}
    end else begin
      ShowMessage(GetTxt({#}'Password was changed'), smInfo, 0);
        {'Heslo bylo zmnno.'}
      break;
    end;
  until false;
  EncryptedPassword := EncryptPassword(s);
end;

procedure EncryptedPasswordSet(const APassword: string);
  { use to set value from e.g. ini file }
begin
  EncryptedPassword := APassword;
end;

function EncryptedPasswordGet: string;
  { use to get value for storing in ini file }
begin
  Result := EncryptedPassword;
end;

{procedure PasswordSet(const APassword: string);
begin
  EncryptedPassword := EncryptPassword(APassword);
end;}

begin
{  AddGlobalVar('[Security]','EncryptedPassword',@EncryptedPassword, ptString, sizeof(EncryptedPassword));}
end.
