unit SelectDateTimeFrm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, Language;

type
  TSelectDateTimeForm = class(TForm)
    DateTimePicker1: TDateTimePicker;
    OKButton: TButton;
    DateTimeLabel1: TLabel;
    DateTimePicker2: TDateTimePicker;
    CancelButton: TButton;
    DateTimeLabel2: TLabel;
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  SelectDateTimeForm: TSelectDateTimeForm;

function SelectMonth(const ATitle: string; var ADateTime: TDateTime): boolean;

implementation

{$R *.DFM}

function SelectMonth(const ATitle: string; var ADateTime: TDateTime): boolean;
var f: TSelectDateTimeForm;
begin
  Result := false;
  f := TSelectDateTimeForm.Create(nil);
  try
    if ATitle <> '' then
      f.Caption := ATitle
    else
      f.Caption := GetTxt({#}'Select month');
    f.DateTimeLabel2.Visible := false;
    f.DateTimePicker2.Visible := false;
    f.DateTimePicker1.DateTime := ADateTime;
    f.DateTimePicker1.Kind := dtkDate;
    f.DateTimeLabel1.Caption := GetTxt({#}'Month');
    if f.ShowModal = mrOK then begin
      ADateTime := f.DateTimePicker1.DateTime;
      Result := true;
    end;
  finally
    f.Free;
  end;
end;

end.
