program ulf2asc;
{$APPTYPE CONSOLE} 
uses
  SysUtils, ulobju, ulfobju;

procedure convert(src, dest:string);
var
  f: TULFObj;
  srcisAsc:boolean;
begin
  f := TULFObj.Create(nil);
  try
    f.LoadFromFile(src);
    srcIsAsc := pos('.ASC', UpperCase(src)) > 0;
    if dest = '' then
      dest := src;
    if srcIsAsc then
      dest := ChangeFileExt(dest, '.ULF')
    else
      dest := ChangeFileExt(src, '.ASC');
    f.SaveToFile(dest);
  finally
    f.Free;
  end;
end;

begin
  if paramcount = 0 then begin
    writeln;
    writeln('Usage: ulf2asc sourcename[.ULF] [destname[.ASC]]');
    writeln('       or');
    writeln('       ulf2asc sourcename.ASC [destname[.ULF]]');
    writeln;
    writeln('Converts Chromulan data files (.ULF) to human readable,');
    writeln('format in ASCII (eventually ASC to ULF)');
  end else begin
    convert(paramstr(1), paramstr(2));
  end;
end.
