program ChromuLan;
{
  (C) 2000 - 2001 Jindrich Jindrich, Pavel Pisa, PiKRON Ltd.

  Originators of the CHROMuLAN project:

  Jindrich Jindrich - http://www.jindrich.com
                      http://orgchem.natur.cuni.cz/Chromulan
                      software developer, project coordinator
  Pavel Pisa        - http://cmp.felk.cvut.cz/~pisa
                      embeded software developer
  PiKRON Ltd.       - http://www.pikron.com
                      project initiator, sponsor, instrument developer

  The CHROMuLAN project is distributed under the GNU General Public Licence.
  See file COPYING for details.

  Originators reserve the right to use and publish sources
  under different conditions too. If third party contributors
  do not accept this condition, they can delete this statement
  and only GNU license will apply.
}

uses
  frstunit in 'frstunit.pas',
  Forms,
  Main in 'Main.pas' {MainForm},
  SpecForm in 'SpecForm.pas' {SpectrumForm},
  MargDial in 'MargDial.pas' {MarginsDialog},
  Plotu in 'Plotu.pas',
  Spectrum in 'Spectrum.pas',
  UlanType in 'UlanType.pas',
  DebugFrm in 'DebugFrm.pas' {DebugForm},
  DrawBuf in 'DrawBuf.pas',
  AboutFrm in 'AboutFrm.pas' {ULAboutBox},
  CommFrm in 'CommFrm.pas' {CommForm},
  UlanGlob in 'UlanGlob.pas',
  DevMode in 'DevMode.pas',
  DevSetFr in 'DevSetFr.pas' {DevSetupForm},
  ComInfo in 'ComInfo.pas' {CommInfoForm},
  FiltDlg in 'FiltDlg.pas' {FilterParsForm},
  TXUlan in 'TXUlan.pas',
  ExpImpu in 'ExpImpu.pas',
  MouseLin in 'MouseLin.pas',
  Axisu in 'Axisu.pas',
  PumpFrm in 'PumpFrm.pas' {PumpForm},
  ulau in 'ulau.pas',
  Report in 'Report.pas' {Form2},
  mathcopr in 'mathcopr.pas',
  InfoFrm in 'infofrm.pas' {ShowInfoForm},
  FileNewDlg in 'FileNewDlg.pas' {FileNewDialog},
  AnalSetupFrm in 'AnalSetupFrm.pas' {AnalSetupForm},
  ULDRu in 'uldru.pas',
  Channelsu in 'Channelsu.pas',
  AcqInfou in 'AcqInfou.pas',
  ULPrgu in 'ULPrgu.pas',
  AAFrm in 'AAFrm.pas' {AAForm},
  Prgu in 'Prgu.pas',
  Sequenceu in 'Sequenceu.pas',
  Timersu in 'Timersu.pas',
  Peaksu in 'Peaksu.pas',
  XGridFrm in 'XGridFrm.pas' {XGridForm},
  ULPrnFrm in 'ULObj\ULPrnFrm.pas' {ULPrnForm},
  ULObjPrn in 'ULObj\ULObjPrn.pas',
  SeqFrm in 'SeqFrm.pas' {SeqForm},
  SModulu in 'SModulu.pas',
  ULObjUsrTreeFrm in 'ULObjUsrTreeFrm.pas' {ULObjUsrTreeForm},
  ULDrvSetFrm in 'ULDrvSetFrm.pas' {ULDrvSetForm},
  OptionsFrm in 'OptionsFrm.pas' {OptionsForm},
  ULDrvFilteru in 'ULDrvFilteru.pas',
  MikroType in 'MikroType.pas',
  DataLineu in 'DataLineu.pas',
  SeqPrgToDevu in 'SeqPrgToDevu.pas',
  ULScriptu in 'ulscriptu.pas',
  ULScriptType in 'ulscripttype.pas',
  ProcessFrm in 'ProcessFrm.pas' {ProcessForm};

{$R *.RES}
{$R TXULAN.RES}
exports
  ULDREDIT,
  ULAEDIT
  {ULDRBROWSE
   ULDBROWSE};
begin
  Application.HelpFile := 'Chromulan.hlp';
  Application.Title := 'Chromulan';
  Application.CreateForm(TMainForm, MainForm);
  Application.CreateForm(TShowInfoForm, ShowInfoForm);
  Application.CreateForm(TULDrvSetForm, ULDrvSetForm);
  Application.CreateForm(TOptionsForm, OptionsForm);
  if not MainForm.OneInstance.IsFirstInstance then
    exit;

  Application.CreateForm(TMarginsDialog, MarginsDialog);
  Application.CreateForm(TULAboutBox, ULAboutBox);
  Application.CreateForm(TDevSetupForm, DevSetupForm);
  Application.CreateForm(TCommInfoForm, CommInfoForm);
  Application.CreateForm(TFilterParsForm, FilterParsForm);
  {Application.CreateForm(TDebugForm, DebugForm);}
  Application.CreateForm(TForm2, Form2);
  {v0.10}{/v0.10
  if paramcount > 0 then begin
    CreateSpectrumForm(paramstr(1), omRead);
  end;}
  Application.Run;
end.
