program txt2uld;{ converts ascii data to ulan data file }
{
  (C) 2000 - 2001 Jindrich Jindrich, Pavel Pisa, PiKRON Ltd.

  Originators of the CHROMuLAN project:

  Jindrich Jindrich - http://www.jindrich.com
                      http://orgchem.natur.cuni.cz/Chromulan
                      software developer, project coordinator
  Pavel Pisa        - http://cmp.felk.cvut.cz/~pisa
                      embeded software developer
  PiKRON Ltd.       - http://www.pikron.com
                      project initiator, sponsor, instrument developer

  The CHROMuLAN project is distributed under the GNU General Public Licence.
  See file COPYING for details.

  Originators reserve the right to use and publish sources
  under different conditions too. If third party contributors
  do not accept this condition, they can delete this statement
  and only GNU license will apply.
}
uses stru, strstrm, ulantype, apextype;
type
  TConvOptions = longint;
  TConvResult = integer;

function Convert(InFile:string; OutFile:string; Options:TConvOptions):TConvResult;
var
  fin:text;
  fout:file of TApexPoint;
  s:string;
  sub:string;
  ss:TStringStream;
  r1,r2:single;
  time:longint;
  ap:TApexPoint;
  code:integer;
  p:integer;
const
  timedif:longint = 100;
begin
  assign(fin, InFile);
  {$I-}
  reset(fin);
  if ioresult <> 0 then begin
    writeln('Can not open ' + InFile);
    exit;
  end;
  assign(fout, OutFile);
  rewrite(fout);
  if ioresult <> 0 then begin
    writeln('Can not create ' + OutFile);
    exit;
  end;
  ss.Init('');
  ss.SetDelimitors([' ',#9,';']);
  time := 0;
  while not eof(fin) do begin
    readln(fin, s);
    s := trim(s);
    if s <> '' then begin
      ss.SetBuffer(s);
      if ss.ReadString(sub) then begin
        if sub <> '' then begin
          if sub[length(sub)] in [',',';'] then
            dec(sub[0]);
          repeat
            p := pos(',', sub);
            if p <> 0 then begin
              sub[p] := '.';
            end;
          until p = 0;
          val(sub, r1, code);
          if code <> 0 then begin
            writeln('Input error: ' + s);
            break;
          end;
          if ss.ReadString(sub) then begin
            val(sub, r2, code);
            if code <> 0 then begin
              writeln('Input error: ' + s);
              break;
            end;
          end else begin
            r2 := r1;
            r1 := time;
            time := time + timedif;
          end;
          ap.X := round(r1);
          ap.Y := single(r2);
          write(fout, ap);
        end;
      end;
    end;
  end;
  ss.Done;
  close(fin);
  close(fout);
end;

begin
  if paramcount < 2 then begin
    writeln('Usage: TXT2ULD inputfile outputfile');
    writeln('Converts ascii file with x,y values to ULan data file.');
    writeln('If just one number found in line, then it is considered');
    writeln('to be y value and time is beeing calculated automatically');
    writeln('in increments 100 ms');
  end else begin
    Convert(paramstr(1), paramstr(2), 0);
  end;
end.