unit testform;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Printers, fontutl, stru, mylib, GSwitch, ASswitch,
  RackCtls, ExtCtrls, ComCtrls, TempGenerator, FoldrDlg, LsFileExplorer26,
  FileCtrl, LedAnzeige, Led, PBNumEdit, Clipbrd, beeper, HiResTim,
  PBSystem, Registry, HJHelp;

type
  TForm1 = class(TForm)
    Edit1: TEdit;
    ScrollBar1: TScrollBar;
    PrintBtn: TButton;
    TextEdit: TEdit;
    XEdit: TEdit;
    YEdit: TEdit;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    FloatEdit: TEdit;
    DecEdit: TEdit;
    FloatToDec: TButton;
    ManEdit: TEdit;
    Button1: TButton;
    FileDialogBtn: TButton;
    teststr: TButton;
    ScrewPanel1: TScrewPanel;
    LEDDisplay1: TLEDDisplay;
    LEDMeter1: TLEDMeter;
    LEDButton1: TLEDButton;
    ButtonPanel2: TButtonPanel;
    Switch2: TSwitch;
    TrackBar: TTrackBar;
    ProgressBar1: TProgressBar;
    ASSwitcher1: TASSwitcher;
    TempGenerator1: TTempGenerator;
    FolderDialog1: TFolderDialog;
    Button2: TButton;
    LsDirTreeCombo261: TLsDirTreeCombo26;
    LsFileListView261: TLsFileListView26;
    Led1: TLed;
    LedAnzeige1: TLedAnzeige;
    LedAnzeige2: TLedAnzeige;
    Button3: TButton;
    HiResTimer: THiResTimer;
    BTBeeper: TBTBeeper;
    Timer1: TTimer;
    TrackEdit: TEdit;
    Button4: TButton;
    Button5: TButton;
    PBSystemPath1: TPBSystemPath;
    Button6: TButton;
    Button7: TButton;
    WinExecEdit: TEdit;
    ResultEdit: TEdit;
    hcIntroduction_Button8: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure ScrollBar1Change(Sender: TObject);
    procedure PrintBtnClick(Sender: TObject);
    procedure FloatToDecClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FileDialogBtnClick(Sender: TObject);
    procedure teststrClick(Sender: TObject);
    procedure ASSwitcher1Change(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Switch2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure HiResTimerTimer(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormHide(Sender: TObject);
    procedure TrackBarChange(Sender: TObject);
    procedure ButtonPanel2Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure hcIntroduction_Button8Click(Sender: TObject);
  private
    { Private declarations }
    hjh: THJHelp;
  public
    { Public declarations }
    at: TAngleText;
    procedure PaintAngle;
    procedure Print;
  end;

var
  Form1: TForm1;

implementation

uses
  {Debugfrm, }
  filedlg,
  alrep, alprev, alprevfr, drawmeta;



{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
var
  i:integer;
begin
  at := TAngleText.Create(90);
  PaintAngle;
  hjh := THJHelp.Create(Self);
end;

const
  Texts:array[1..10]of shortstring = ('2234l as0d9fu','23lklxxx 23krj',
    '2394ssailw45u8', 'alk3j5 0d9fvj', '2304dmnv qei4ogt834',
    ',bv=h23kzD f;qow3i4j ', 'a;sl495u lskvn ', 'cvoibh58t 2sldkf',
    '2095 sdjfvn3408r', 'lkjb 3049tu skd');

procedure TForm1.PaintAngle;
var i:integer;
begin
  Canvas.Ellipse(88,38, 92,43);
  {Canvas.Rectangle(70, 40, 250, 40 + 10 * Canvas.TextWidth('X'));}
  for i := 1 to 1 do begin
    at.TextOut(true, Canvas, clRed, 50 + i * 40, 40, Pad(Texts[i],10{Random(10)+1}));
  end;
end;

procedure TForm1.FormPaint(Sender: TObject);
begin
  PaintAngle;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  at.Free;
  hjh.Free;
end;

procedure TForm1.Edit1Change(Sender: TObject);
var code,i:integer;
begin
  val(Edit1.Text, i, code);
  if code = 0 then begin
    at.Angle := StrToInt(Edit1.Text);
    invalidate;
  end;
end;

procedure TForm1.ScrollBar1Change(Sender: TObject);
begin
  at.Angle := ScrollBar1.Position;
  invalidate;

end;

procedure TForm1.PrintBtnClick(Sender: TObject);
begin
  Print;
end;

procedure TForm1.Print;
var w,h:integer; p: TPrinter;
begin
  p := Printer;
  w := p.PageWidth;
  h := p.PageHeight;
  Canvas.Lock;
  try
    p.BeginDoc;
    at.TextOut(false, p.Canvas, clRed, StrToInt(XEdit.Text), StrToInt(YEdit.Text), TextEdit.Text);
    p.EndDoc;
  finally
    Canvas.UnLock;
  end;
end;

procedure TForm1.FloatToDecClick(Sender: TObject);
var
  f: extended;
  fr: TFloatRec;
  r,m: real;
  code: integer;
  l: integer;
begin
  val(FloatEdit.Text, f, code);
  FloatToDecimal(fr, f, fvExtended, 10, 9999);
  DecEdit.Text := IntToStr(fr.Exponent) + ' ' + fr.Digits;
  r := f;
{  getmanlog(r, m, l);}
  ManEdit.Text := FloatToRoundStr(f, 3, 0);{IntToStr(l) + ' ' + FloatToStr(m);}
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  Canvas.Pen.Mode := pmCopy;
  Canvas.Pen.Color := clYellow;
  Canvas.Brush.Color := clBlue;
  Canvas.Font.Color := clYellow;
  Canvas.TextOut(100, 100, 'TEXT');
end;

procedure TForm1.FileDialogBtnClick(Sender: TObject);
begin
  FileDialog.ShowModal;
end;

procedure TForm1.teststrClick(Sender: TObject);
{var
  f,f2: TULFObj;
  o,u: TULObj;
const
  testfn1 = 'testfn1.~$$';
  testfn2 = 'testfn2.~$$';
begin
  if FileExists(testfn1) then
    f := TULFObj.Load(testfn1)
  else
    f := TULFObj.Create(nil);
  o := f.FindOrAdd(ULUID, '');
  u := o.FindOrAdd(ULURID, '');
  f.Browse;
  f.SaveToFile(testfn1);
  f2 := TULFObj.Create(nil);
  f2.Assign(f);
  f2.Browse;
  f2.SaveToFile(testfn2);
  f2.Free;
  f.Free;
end;}
begin
end;

procedure TForm1.ASSwitcher1Change(Sender: TObject);
begin
  LEDDisplay1.Value := ASSwitcher1.Position;
  LEDMeter1.Position :=  ASSwitcher1.Position;
end;
{sfoDesktop}
procedure TForm1.Button2Click(Sender: TObject);
begin
  FolderDialog1.Execute;
  Button2.Caption := FolderDialog1.Directory;
end;

procedure TForm1.Switch2Click(Sender: TObject);
begin
  Led1.OnOff := Switch2.Checked;
end;

procedure TForm1.Button3Click(Sender: TObject);
var
  rep        : tAlReport;
  frm        : tForm;

  Total      : extended;
  Count: integer;
  GrandTotal : extended;
  GrandCount: integer;

  g, i: integer;
  gistr, gstr, istr: string;

  im: TAlImage;
  mf: TDrawMetaFile;
  p: TPen;
const
  repname = 'alrepfrm.dfm';
  testcnt = 20;
  testgrp = 3;
begin
  if LoadReport(repname,rep,frm) then
  begin
    GrandTotal := 0;
    GrandCount := 0;
    for g := 0 to testgrp - 1 do begin
      gstr := IntToStr(g);
      Total := 0;
      Count := 0;
      for i := 0 to testcnt * g - 1 do begin
        istr := IntToStr(i);
        gistr := gstr + ' ' + istr;
        // All fields that appear in the DetailLink Bands
        //   GroupHeader, GroupFooter, GroupBand
        // Must appear as Details in the Data List.
        // Also they must appear in the Detail Band as originally
        //    named values e.g. "CustNo".
        //    You set their visible-property to false, if they
        //    should not be printed.
        // When printed in the GroupHeader/GroupFooter you add them
        //    as copied values e.g. "CustNo_".
        // Group Header/Footer values
         rep.AddNamedValue('GroupID', gstr);
         rep.AddNamedValue('GroupName', 'Group ' + gstr);
         {rep.AddNamedValue('GroupID_', gstr);
         rep.AddNamedValue('GroupName_', 'Group ' + gstr);}
         // details
         rep.AddNamedValue ('Name',  'Name ' + gstr + ' ' + istr);
         rep.AddNamedValue ('Street', 'Street ' + istr);
         rep.AddNamedValue('ZipCode', '100'+ istr);
         rep.AddNamedValue ('Place', 'Place ' + istr);
         rep.AddNamedValue('Amount', istr);
         rep.AddNamedValue('Note', gstr);
         // calculate the total
         Total := Total + i;
         Count := Count + 1;
         // Group Header/Footer values
         // Note: this can be a calculated value, so we add it
         // after the static values, because normally you do
         // calculation after data-retrieval.
         rep.AddNamedValue ('GroupCount', IntToStr(count){Format('%n',[Count])});
         rep.AddNamedValue ('GroupSum', Format('%n',[Total]));
      end;
      // calculate the GrandTotal.
      GrandTotal := GrandTotal + Total;
    end;
    // Now add the GrandTotal to the report. It's just a single value
    // printed in the report-footer.
    rep.AddNamedValue ('Sum', Format('%n',[GrandTotal]));
    // preview or print

    with TFrmPreview.Create(Application) do
    begin
      im := TAlImage(frm.FindComponent('HeaderImage'));
      if im <> nil then begin
        p := TPen.Create;
        mf := TDrawMetaFile.Create(100, 100);
        p.Assign(mf.Canvas.Pen);
        mf.Canvas.MoveTo(0,0);
        mf.Canvas.LineTo(99,99);
        mf.Close;
        im.Picture.Assign(TMetaFile(mf));
        mf.Free;
        p.Free;
      end;
      rep.MakePreviewPages(Previewer.Pages);
      FirstPage;
    end;
    // cleanup
    frm.Release;
  end else begin
    MessageDlg (Format('could not load report %s',[repname]),
                 mtError,[mbOK],0);
  end;
end;


procedure TForm1.HiResTimerTimer(Sender: TObject);
begin
  if (csDestroying in ComponentState) then
     exit;
  if Switch2.Checked then
    BTBeeper.BeepFor(TrackBar.Position, 100);

end;

procedure TForm1.FormShow(Sender: TObject);
begin
  HiResTimer.Enabled := true;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
  if (csDestroying in ComponentState) then
     exit;
  if not Switch2.Checked then
     BTBeeper.BeepFor(TrackBar.Position, 100);
end;

procedure TForm1.FormHide(Sender: TObject);
begin
  HiResTimer.Enabled := false;
end;

procedure TForm1.TrackBarChange(Sender: TObject);
begin
  TrackEdit.Text := IntToStr(TrackBar.Position);
end;

procedure TForm1.ButtonPanel2Click(Sender: TObject);
begin
  BTBeeper.PlayTextFile('lib\beeperso.txt','Yesterday');
end;

procedure TForm1.Button4Click(Sender: TObject);
{var
  r:integer;
  dl: TDevDrv;

begin
  dl := TDevDrv.Create('ul_drv',0);
  r := dl.CheckDeviceStarted;
  if r <> 0 then
    ShowMessage('Device start failed: ' + dl.LastResultMsg);
  dl.Free;
end;}
begin
end;

procedure TForm1.Button5Click(Sender: TObject);
{var
  r:integer;
  dl: TDevDrv;
begin
  dl := TDevDrv.Create('ul_drv', 0);
  if dl <> nil then begin
    r := dl.CheckDeviceStopped(true, false);
    if r <> 0 then
      ShowMessage('Device stop failed: ' + dl.LastResultMsg);
    dl.Free;
    dl := nil;
  end;
end;}
begin
end;

procedure TForm1.Button6Click(Sender: TObject);
var
  r:TRegistry;
  key:string;
  sl:TStringList;
begin
  r := TRegistry.Create;
  r.RootKey := HKEY_LOCAL_MACHINE;
  sl := TStringList.Create;
{  [HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\ul_drv]}
  key := 'SYSTEM\CurrentControlSet';
  if not r.OpenKey(key, false) then
    ShowMessage('openkey failed.');
  if not r.OpenKey('Services', false) then
     ShowMessage('openkey failed.');
  r.GetKeyNames(sl);
  if sl.Count = 0 then
     ShowMessage('getkeynames failed.');


{  if not r.LoadKey('ul_drv', 'uldrv\ul_drv2.reg') then
    ShowMessage('ul_drv load failed.');}
   sl.Free;
end;

procedure TForm1.Button7Click(Sender: TObject);
var
  l:integer;
  c:array[0..255]of char;
begin
  StrPCopy(c, WinExecEdit.Text);
  l :=  WinExec(c,0);
  ResultEdit.Text := IntToStr(l);
end;

procedure TForm1.hcIntroduction_Button8Click(Sender: TObject);
begin
  Application.HelpJump('hcIntroduction');
end;

end.
